/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.SqlException;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;

public final class IntervalUtils {
    public static final int HI_INDEX = 1;
    public static final int LO_INDEX = 0;
    public static final int OPERATION_PERIOD_TYPE_ADJUSTMENT_INDEX = 2;
    public static final int PERIOD_COUNT_INDEX = 3;
    public static final int STATIC_LONGS_PER_DYNAMIC_INTERVAL = 4;

    public static void addHiLoInterval(long lo, long hi, int period, char periodType, int periodCount, short operation, LongList out) {
        IntervalUtils.addHiLoInterval(lo, hi, period, periodType, periodCount, (short)0, (short)0, operation, out);
    }

    public static void addHiLoInterval(long lo, long hi, int period, char periodType, int periodCount, short adjustment, short dynamicIndicator, short operation, LongList out) {
        out.add(lo, hi, Numbers.encodeLowHighInts(Numbers.encodeLowHighShorts(operation, (short)(periodType + Short.MIN_VALUE)), Numbers.encodeLowHighShorts(adjustment, dynamicIndicator)), Numbers.encodeLowHighInts(period, periodCount));
    }

    public static void addHiLoInterval(long lo, long hi, short adjustment, short dynamicIndicator, short operation, LongList out) {
        IntervalUtils.addHiLoInterval(lo, hi, 0, '\u0000', 1, adjustment, dynamicIndicator, operation, out);
    }

    public static void addHiLoInterval(long lo, long hi, short operation, LongList out) {
        IntervalUtils.addHiLoInterval(lo, hi, 0, '\u0000', 1, operation, out);
    }

    public static void apply(LongList temp, long lo, long hi, int period, char periodType, int count) {
        temp.add(lo, hi);
        if (count > 1) {
            switch (periodType) {
                case 'y': {
                    IntervalUtils.addYearIntervals(period, count, temp);
                    break;
                }
                case 'M': {
                    IntervalUtils.addMonthInterval(period, count, temp);
                    break;
                }
                case 'h': {
                    IntervalUtils.addMillisInterval((long)period * 3600000000L, count, temp);
                    break;
                }
                case 'm': {
                    IntervalUtils.addMillisInterval((long)period * 60000000L, count, temp);
                    break;
                }
                case 's': {
                    IntervalUtils.addMillisInterval((long)period * 1000000L, count, temp);
                    break;
                }
                case 'd': {
                    IntervalUtils.addMillisInterval((long)period * 86400000000L, count, temp);
                }
            }
        }
    }

    public static void applyLastEncodedIntervalEx(LongList intervals) {
        int index = intervals.size() - 4;
        long lo = IntervalUtils.getEncodedPeriodLo(intervals, index);
        long hi = IntervalUtils.getEncodedPeriodHi(intervals, index);
        int period = IntervalUtils.getEncodedPeriod(intervals, index);
        char periodType = IntervalUtils.getEncodedPeriodType(intervals, index);
        int count = IntervalUtils.getEncodedPeriodCount(intervals, index);
        intervals.setPos(index);
        if (periodType == '\u0000') {
            intervals.extendAndSet(index + 1, hi);
            intervals.setQuick(index, lo);
            return;
        }
        IntervalUtils.apply(intervals, lo, hi, period, periodType, count);
    }

    public static short getEncodedAdjustment(LongList intervals, int index) {
        return Numbers.decodeLowShort(Numbers.decodeHighInt(intervals.getQuick(index + 2)));
    }

    public static short getEncodedDynamicIndicator(LongList intervals, int index) {
        return Numbers.decodeHighShort(Numbers.decodeHighInt(intervals.getQuick(index + 2)));
    }

    public static short getEncodedOperation(LongList intervals, int index) {
        return Numbers.decodeLowShort(Numbers.decodeLowInt(intervals.getQuick(index + 2)));
    }

    public static int getEncodedPeriod(LongList intervals, int index) {
        return Numbers.decodeLowInt(intervals.getQuick(index + 3));
    }

    public static int getEncodedPeriodCount(LongList intervals, int index) {
        return Numbers.decodeHighInt(intervals.getQuick(index + 3));
    }

    public static long getEncodedPeriodHi(LongList out, int index) {
        return out.getQuick(index + 1);
    }

    public static long getEncodedPeriodLo(LongList out, int index) {
        return out.getQuick(index + 0);
    }

    public static char getEncodedPeriodType(LongList intervals, int index) {
        short pts = Numbers.decodeHighShort(Numbers.decodeLowInt(intervals.getQuick(index + 2)));
        return (char)(pts - Short.MIN_VALUE);
    }

    public static boolean isInIntervals(LongList intervals, long timestamp) {
        int left = 0;
        int right = intervals.size() / 2 - 1;
        while (left <= right) {
            int mid = (left + right) / 2;
            long lo = IntervalUtils.getEncodedPeriodLo(intervals, mid * 2);
            long hi = IntervalUtils.getEncodedPeriodHi(intervals, mid * 2);
            if (lo > timestamp) {
                right = mid - 1;
                continue;
            }
            if (hi < timestamp) {
                left = mid + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static long parseCCPartialDate(CharSequence seq, int pos, int lim) throws NumericException {
        long ts;
        if (lim - pos < 4) {
            throw NumericException.INSTANCE;
        }
        int p = pos;
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Timestamps.isLeapYear(year);
        if (IntervalUtils.checkLen(p, lim)) {
            IntervalUtils.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            IntervalUtils.checkRange(month, 1, 12);
            if (IntervalUtils.checkLen(p, lim)) {
                IntervalUtils.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                IntervalUtils.checkRange(day, 1, Timestamps.getDaysPerMonth(month, l));
                if (IntervalUtils.checkLen(p, lim)) {
                    IntervalUtils.checkChar(seq, p++, lim, 'T', ' ');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    IntervalUtils.checkRange(hour, 0, 23);
                    if (IntervalUtils.checkLen(p, lim)) {
                        IntervalUtils.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        IntervalUtils.checkRange(min, 0, 59);
                        if (IntervalUtils.checkLen(p, lim)) {
                            IntervalUtils.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            IntervalUtils.checkRange(sec, 0, 59);
                            if (lim - p > 3 && seq.charAt(p) == '.') {
                                int ms = Numbers.parseInt(seq, ++p, p += 3);
                                if (lim - p > 2 && Character.isDigit(seq.charAt(p))) {
                                    int micr = Numbers.parseInt(seq, p, p += 3);
                                    ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + (long)ms * 1000L + (long)micr + IntervalUtils.checkTimezoneTail(seq, p, lim) + 1L;
                                } else {
                                    ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + (long)(ms + 1) * 1000L + IntervalUtils.checkTimezoneTail(seq, p, lim);
                                }
                            } else {
                                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)(sec + 1) * 1000000L + IntervalUtils.checkTimezoneTail(seq, p, lim);
                            }
                        } else {
                            ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)(min + 1) * 60000000L;
                        }
                    } else {
                        ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)(hour + 1) * 3600000000L;
                    }
                } else {
                    ts = Timestamps.addDays(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L, 1);
                }
            } else {
                ts = Timestamps.addMonths(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l), 1);
            }
        } else {
            ts = Timestamps.yearMicros(year + 1, Timestamps.isLeapYear(year + 1));
        }
        return ts;
    }

    public static long parseCCPartialDate(CharSequence seq) throws NumericException {
        return IntervalUtils.parseCCPartialDate(seq, 0, seq.length());
    }

    public static long parseFloorPartialTimestamp(CharSequence seq, int pos, int lim) throws NumericException {
        long ts;
        if (lim - pos < 4) {
            throw NumericException.INSTANCE;
        }
        int p = pos;
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Timestamps.isLeapYear(year);
        if (IntervalUtils.checkLen(p, lim)) {
            IntervalUtils.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            IntervalUtils.checkRange(month, 1, 12);
            if (IntervalUtils.checkLen(p, lim)) {
                IntervalUtils.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                IntervalUtils.checkRange(day, 1, Timestamps.getDaysPerMonth(month, l));
                if (IntervalUtils.checkLen(p, lim)) {
                    IntervalUtils.checkChar(seq, p++, lim, 'T', ' ');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    IntervalUtils.checkRange(hour, 0, 23);
                    if (IntervalUtils.checkLen(p, lim)) {
                        IntervalUtils.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        IntervalUtils.checkRange(min, 0, 59);
                        if (IntervalUtils.checkLen(p, lim)) {
                            IntervalUtils.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            IntervalUtils.checkRange(sec, 0, 59);
                            if (p < lim && seq.charAt(p) == '.') {
                                char c;
                                int micrLim = ++p + 6;
                                int mlim = Math.min(lim, micrLim);
                                int micr = 0;
                                while (p < mlim && (c = seq.charAt(p)) >= '0' && c <= '9') {
                                    micr *= 10;
                                    micr += c - 48;
                                    ++p;
                                }
                                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + (long)(micr *= IntervalUtils.tenPow(micrLim - p)) + IntervalUtils.checkTimezoneTail(seq, p, lim);
                            } else {
                                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + IntervalUtils.checkTimezoneTail(seq, p, lim);
                            }
                        } else {
                            ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L;
                        }
                    } else {
                        ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L;
                    }
                } else {
                    ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L;
                }
            } else {
                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l);
            }
        } else {
            ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(1, l);
        }
        return ts;
    }

    public static long parseFloorPartialTimestamp(CharSequence seq) throws NumericException {
        return IntervalUtils.parseFloorPartialTimestamp(seq, 0, seq.length());
    }

    public static void parseInterval(CharSequence seq, int pos, int lim, short operation, LongList out) throws NumericException {
        if (lim - pos < 4) {
            throw NumericException.INSTANCE;
        }
        int p = pos;
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Timestamps.isLeapYear(year);
        if (IntervalUtils.checkLen(p, lim)) {
            IntervalUtils.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            IntervalUtils.checkRange(month, 1, 12);
            if (IntervalUtils.checkLen(p, lim)) {
                IntervalUtils.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                IntervalUtils.checkRange(day, 1, Timestamps.getDaysPerMonth(month, l));
                if (IntervalUtils.checkLen(p, lim)) {
                    IntervalUtils.checkChar(seq, p++, lim, 'T');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    IntervalUtils.checkRange(hour, 0, 23);
                    if (IntervalUtils.checkLen(p, lim)) {
                        IntervalUtils.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        IntervalUtils.checkRange(min, 0, 59);
                        if (IntervalUtils.checkLen(p, lim)) {
                            IntervalUtils.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            IntervalUtils.checkRange(sec, 0, 59);
                            if (p < lim) {
                                throw NumericException.INSTANCE;
                            }
                            IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L, Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + 999999L, operation, out);
                        } else {
                            IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L, Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + 59000000L + 999999L, operation, out);
                        }
                    } else {
                        IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L, Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + 3540000000L + 59000000L + 999999L, operation, out);
                    }
                } else {
                    IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L, Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L, operation, out);
                }
            } else {
                IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l), Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(Timestamps.getDaysPerMonth(month, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L, operation, out);
            }
        } else {
            IntervalUtils.addHiLoInterval(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(1, l), Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(12, l) + (long)(Timestamps.getDaysPerMonth(12, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L, operation, out);
        }
    }

    public static void parseIntervalEx(CharSequence seq, int lo, int lim, int position, LongList out, short operation) throws SqlException {
        int writeIndex = out.size();
        int[] pos = new int[3];
        int p = -1;
        for (int i = lo; i < lim; ++i) {
            if (seq.charAt(i) != ';') continue;
            if (p > 1) {
                throw SqlException.$(position, "Invalid interval format");
            }
            pos[++p] = i;
        }
        block5 : switch (p) {
            case -1: {
                try {
                    IntervalUtils.parseInterval(seq, lo, lim, operation, out);
                    break;
                }
                catch (NumericException i) {
                    try {
                        long millis = IntervalUtils.parseFloorPartialTimestamp(seq, lo, lim);
                        IntervalUtils.addHiLoInterval(millis, millis, operation, out);
                        break;
                    }
                    catch (NumericException e) {
                        try {
                            long millis = Numbers.parseLong(seq);
                            IntervalUtils.addHiLoInterval(millis, millis, operation, out);
                            break;
                        }
                        catch (NumericException e2) {
                            throw SqlException.$(position, "Invalid date");
                        }
                    }
                }
            }
            case 0: {
                IntervalUtils.parseRange(seq, lo, pos[0], lim, position, operation, out);
                break;
            }
            case 2: {
                int count;
                int period;
                try {
                    period = Numbers.parseInt(seq, pos[1] + 1, pos[2] - 1);
                }
                catch (NumericException e) {
                    throw SqlException.$(position, "Period not a number");
                }
                try {
                    count = Numbers.parseInt(seq, pos[2] + 1, lim);
                }
                catch (NumericException e) {
                    throw SqlException.$(position, "Count not a number");
                }
                IntervalUtils.parseRange(seq, lo, pos[0], pos[1], position, operation, out);
                char type = seq.charAt(pos[2] - 1);
                long low = IntervalUtils.getEncodedPeriodLo(out, writeIndex);
                long hi = IntervalUtils.getEncodedPeriodHi(out, writeIndex);
                IntervalUtils.replaceHiLoInterval(low, hi, period, type, count, operation, out);
                switch (type) {
                    case 'M': 
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 's': 
                    case 'y': {
                        break block5;
                    }
                }
                throw SqlException.$(position, "Unknown period: " + type + " at " + (p - 1));
            }
            default: {
                throw SqlException.$(position, "Invalid interval format");
            }
        }
    }

    public static void parseSingleTimestamp(CharSequence seq, int lo, int lim, int position, LongList out, short operation) throws SqlException {
        try {
            long millis = IntervalUtils.parseFloorPartialTimestamp(seq, lo, lim);
            IntervalUtils.addHiLoInterval(millis, millis, operation, out);
        }
        catch (NumericException e) {
            try {
                long millis = Numbers.parseLong(seq);
                IntervalUtils.addHiLoInterval(millis, millis, operation, out);
            }
            catch (NumericException e2) {
                for (int i = lo; i < lim; ++i) {
                    if (seq.charAt(i) != ';') continue;
                    throw SqlException.$(position, "Not a date, use IN keyword with intervals");
                }
                throw SqlException.$(position, "Invalid date");
            }
        }
    }

    public static void subtract(LongList intervals, int divider) {
        IntervalUtils.invert(intervals, divider);
        IntervalUtils.intersectInplace(intervals, divider);
    }

    public static long tryParseTimestamp(CharSequence seq) throws CairoException {
        try {
            return IntervalUtils.parseFloorPartialTimestamp(seq, 0, seq.length());
        }
        catch (NumericException e) {
            throw CairoException.nonCritical().put("Invalid timestamp: ").put(seq);
        }
    }

    private static void addMillisInterval(long period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int writePoint = k / 2;
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            writePoint = IntervalUtils.append(out, writePoint, lo += period, hi += period);
        }
    }

    private static void addMonthInterval(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int writePoint = k / 2;
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Timestamps.addMonths(lo, period);
            hi = Timestamps.addMonths(hi, period);
            writePoint = IntervalUtils.append(out, writePoint, lo, hi);
        }
    }

    private static void addYearIntervals(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int writePoint = k / 2;
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Timestamps.addYear(lo, period);
            hi = Timestamps.addYear(hi, period);
            writePoint = IntervalUtils.append(out, writePoint, lo, hi);
        }
    }

    private static void checkChar(CharSequence s, int p, int lim, char c) throws NumericException {
        if (p >= lim || s.charAt(p) != c) {
            throw NumericException.INSTANCE;
        }
    }

    private static void checkChar(CharSequence s, int p, int lim, char c1, char c2) throws NumericException {
        if (p >= lim || s.charAt(p) != c1 && s.charAt(p) != c2) {
            throw NumericException.INSTANCE;
        }
    }

    private static boolean checkLen(int p, int lim) throws NumericException {
        if (lim - p > 2) {
            return true;
        }
        if (lim <= p) {
            return false;
        }
        throw NumericException.INSTANCE;
    }

    private static boolean checkLenStrict(int p, int lim) throws NumericException {
        if (lim - p == 2) {
            return true;
        }
        if (lim <= p) {
            return false;
        }
        throw NumericException.INSTANCE;
    }

    private static void checkRange(int x, int min, int max) throws NumericException {
        if (x < min || x > max) {
            throw NumericException.INSTANCE;
        }
    }

    private static long checkTimezoneTail(CharSequence seq, int p, int lim) throws NumericException {
        if (lim == p) {
            return 0L;
        }
        if (lim - p < 2) {
            IntervalUtils.checkChar(seq, p, lim, 'Z');
            return 0L;
        }
        if (lim - p > 2) {
            int tzSign = IntervalUtils.parseSign(seq, p++);
            int hour = Numbers.parseInt(seq, p, p += 2);
            IntervalUtils.checkRange(hour, 0, 23);
            if (lim - p == 3) {
                IntervalUtils.checkChar(seq, p++, lim, ':');
            }
            if (IntervalUtils.checkLenStrict(p, lim)) {
                int min = Numbers.parseInt(seq, p, p + 2);
                IntervalUtils.checkRange(min, 0, 59);
                return (long)tzSign * ((long)hour * 3600000000L + (long)min * 60000000L);
            }
            return (long)tzSign * ((long)hour * 3600000000L);
        }
        throw NumericException.INSTANCE;
    }

    private static void parseRange(CharSequence seq, int lo, int p, int lim, int position, short operation, LongList out) throws SqlException {
        int period;
        char type = seq.charAt(lim - 1);
        try {
            period = Numbers.parseInt(seq, p + 1, lim - 1);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "Range not a number");
        }
        try {
            int index = out.size();
            IntervalUtils.parseInterval(seq, lo, p, operation, out);
            long low = IntervalUtils.getEncodedPeriodLo(out, index);
            long hi = IntervalUtils.getEncodedPeriodHi(out, index);
            hi = Timestamps.addPeriod(hi, type, period);
            if (hi < low) {
                throw SqlException.invalidDate(position);
            }
            IntervalUtils.replaceHiLoInterval(low, hi, operation, out);
            return;
        }
        catch (NumericException index) {
            try {
                long loMillis = TimestampFormatUtils.tryParse(seq, lo, p);
                long hiMillis = Timestamps.addPeriod(loMillis, type, period);
                if (hiMillis < loMillis) {
                    throw SqlException.invalidDate(position);
                }
                IntervalUtils.addHiLoInterval(loMillis, hiMillis, operation, out);
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(position);
            }
            return;
        }
    }

    private static int parseSign(CharSequence seq, int p) throws NumericException {
        int tzSign;
        switch (seq.charAt(p)) {
            case '+': {
                tzSign = -1;
                break;
            }
            case '-': {
                tzSign = 1;
                break;
            }
            default: {
                throw NumericException.INSTANCE;
            }
        }
        return tzSign;
    }

    private static void replaceHiLoInterval(long lo, long hi, int period, char periodType, int periodCount, short operation, LongList out) {
        int lastIndex = out.size() - 4;
        out.setQuick(lastIndex, lo);
        out.setQuick(lastIndex + 1, hi);
        out.setQuick(lastIndex + 2, Numbers.encodeLowHighInts(Numbers.encodeLowHighShorts(operation, (short)(periodType + Short.MIN_VALUE)), 0));
        out.setQuick(lastIndex + 3, Numbers.encodeLowHighInts(period, periodCount));
    }

    private static void replaceHiLoInterval(long lo, long hi, short operation, LongList out) {
        IntervalUtils.replaceHiLoInterval(lo, hi, 0, '\u0000', 1, operation, out);
    }

    private static int tenPow(int i) throws NumericException {
        switch (i) {
            case 0: {
                return 1;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 10000;
            }
            case 5: {
                return 100000;
            }
        }
        throw NumericException.INSTANCE;
    }

    static int append(LongList list, int writePoint, long lo, long hi) {
        long prevHi;
        if (writePoint > 0 && (prevHi = list.getQuick(2 * writePoint - 1) + 1L) >= lo) {
            list.setQuick(2 * writePoint - 1, hi);
            return writePoint;
        }
        list.extendAndSet(2 * writePoint + 1, hi);
        list.setQuick(2 * writePoint, lo);
        return writePoint + 1;
    }

    static void intersectInplace(LongList concatenatedIntervals, int dividerIndex) {
        int sizeA = dividerIndex / 2;
        int sizeB = sizeA + (concatenatedIntervals.size() - dividerIndex) / 2;
        int aLower = 0;
        int intervalB = sizeA;
        int writePoint = 0;
        int aUpperSize = sizeB;
        int aUpper = sizeB;
        while ((aLower < sizeA || aUpper < aUpperSize) && intervalB < sizeB) {
            int intervalA = aUpper < aUpperSize ? aUpper : aLower;
            long aLo = concatenatedIntervals.getQuick(intervalA * 2);
            long aHi = concatenatedIntervals.getQuick(intervalA * 2 + 1);
            long bLo = concatenatedIntervals.getQuick(intervalB * 2);
            long bHi = concatenatedIntervals.getQuick(intervalB * 2 + 1);
            if (aHi < bLo) {
                if (aUpper < aUpperSize) {
                    ++aUpper;
                    continue;
                }
                ++aLower;
                continue;
            }
            if (aLo > bHi) {
                ++intervalB;
                continue;
            }
            if (aHi < bHi) {
                if (aUpper < aUpperSize) {
                    ++aUpper;
                } else {
                    ++aLower;
                }
            } else {
                ++intervalB;
            }
            assert (writePoint <= aLower || writePoint >= sizeA);
            if (writePoint == aLower && aLower < sizeA) {
                concatenatedIntervals.add(concatenatedIntervals.getQuick(writePoint * 2), concatenatedIntervals.getQuick(writePoint * 2 + 1));
                aUpperSize = concatenatedIntervals.size() / 2;
                ++aLower;
            }
            writePoint = IntervalUtils.append(concatenatedIntervals, writePoint, Math.max(aLo, bLo), Math.min(aHi, bHi));
        }
        concatenatedIntervals.setPos(2 * writePoint);
    }

    static void invert(LongList intervals) {
        IntervalUtils.invert(intervals, 0);
    }

    static void invert(LongList intervals, int startIndex) {
        long last = Long.MIN_VALUE;
        int n = intervals.size();
        int writeIndex = startIndex;
        for (int i = startIndex; i < n; i += 2) {
            long lo = intervals.getQuick(i);
            long hi = intervals.getQuick(i + 1);
            if (lo > last) {
                intervals.setQuick(writeIndex, last);
                intervals.setQuick(writeIndex + 1, lo - 1L);
                writeIndex += 2;
            }
            last = hi + 1L;
        }
        if (last != Long.MIN_VALUE) {
            intervals.extendAndSet(writeIndex + 1, Long.MAX_VALUE);
            intervals.setQuick(writeIndex, last);
            writeIndex += 2;
        }
        intervals.setPos(writeIndex);
    }

    static void unionInplace(LongList intervals, int dividerIndex) {
        int sizeB = dividerIndex + (intervals.size() - dividerIndex);
        int aLower = 0;
        int intervalB = dividerIndex;
        int writePoint = 0;
        int aUpperSize = sizeB;
        int aUpper = sizeB;
        long aLo = 0L;
        long aHi = 0L;
        long bLo = 0L;
        long bHi = 0L;
        while (aLower < dividerIndex || aUpper < aUpperSize || intervalB < sizeB) {
            long prevHi;
            long nextHi;
            long nextLo;
            boolean hasB;
            boolean hasA;
            boolean bl = hasA = aLower < dividerIndex || aUpper < aUpperSize;
            if (hasA) {
                int intervalA = aUpper < aUpperSize ? aUpper : aLower;
                aLo = intervals.getQuick(intervalA);
                aHi = intervals.getQuick(intervalA + 1);
            }
            boolean bl2 = hasB = intervalB < sizeB;
            if (hasB) {
                bLo = intervals.getQuick(intervalB);
                bHi = intervals.getQuick(intervalB + 1);
            }
            if (hasA) {
                if (hasB && bLo < aLo) {
                    nextLo = bLo;
                    nextHi = bHi;
                    intervalB += 2;
                } else {
                    nextLo = aLo;
                    nextHi = aHi;
                    if (aUpper < aUpperSize) {
                        aUpper += 2;
                    } else {
                        aLower += 2;
                    }
                }
            } else {
                nextLo = bLo;
                nextHi = bHi;
                intervalB += 2;
            }
            if (writePoint > 0 && nextLo <= (prevHi = intervals.getQuick(writePoint - 1))) {
                intervals.setQuick(writePoint - 1, Math.max(nextHi, prevHi));
                continue;
            }
            assert (writePoint <= aLower || writePoint >= dividerIndex);
            if (writePoint == aLower && aLower < dividerIndex) {
                intervals.add(intervals.getQuick(writePoint), intervals.getQuick(writePoint + 1));
                aUpperSize = intervals.size();
                aLower += 2;
            }
            intervals.setQuick(writePoint++, nextLo);
            intervals.setQuick(writePoint++, nextHi);
        }
        intervals.setPos(writePoint);
    }
}

