/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;

@ApiModel
@XmlRootElement
public class VersionedFlowSnapshot {
    @Valid
    @NotNull
    private VersionedFlowSnapshotMetadata snapshotMetadata;
    @Valid
    @NotNull
    private VersionedProcessGroup flowContents;
    private Map<String, ExternalControllerServiceReference> externalControllerServices;
    private Map<String, ParameterProviderReference> parameterProviders;
    private Map<String, VersionedParameterContext> parameterContexts;
    private String flowEncodingVersion;
    private VersionedFlow flow;
    private Bucket bucket;

    @ApiModelProperty(value="The metadata for this snapshot", required=true)
    public VersionedFlowSnapshotMetadata getSnapshotMetadata() {
        return this.snapshotMetadata;
    }

    public void setSnapshotMetadata(VersionedFlowSnapshotMetadata snapshotMetadata) {
        this.snapshotMetadata = snapshotMetadata;
    }

    @ApiModelProperty(value="The contents of the versioned flow", required=true)
    public VersionedProcessGroup getFlowContents() {
        return this.flowContents;
    }

    public void setFlowContents(VersionedProcessGroup flowContents) {
        this.flowContents = flowContents;
    }

    @ApiModelProperty(value="The information about controller services that exist outside this versioned flow, but are referenced by components within the versioned flow.")
    public Map<String, ExternalControllerServiceReference> getExternalControllerServices() {
        return this.externalControllerServices;
    }

    public void setExternalControllerServices(Map<String, ExternalControllerServiceReference> externalControllerServices) {
        this.externalControllerServices = externalControllerServices;
    }

    @ApiModelProperty(value="Contains basic information about parameter providers referenced in the versioned flow.")
    public Map<String, ParameterProviderReference> getParameterProviders() {
        return this.parameterProviders;
    }

    public void setParameterProviders(Map<String, ParameterProviderReference> parameterProviders) {
        this.parameterProviders = parameterProviders;
    }

    @ApiModelProperty(value="The flow this snapshot is for", readOnly=true)
    public VersionedFlow getFlow() {
        return this.flow;
    }

    public void setFlow(VersionedFlow flow) {
        this.flow = flow;
    }

    @ApiModelProperty(value="The bucket where the flow is located", readOnly=true)
    public Bucket getBucket() {
        return this.bucket;
    }

    public void setBucket(Bucket bucket) {
        this.bucket = bucket;
    }

    @ApiModelProperty(value="The parameter contexts referenced by process groups in the flow contents. The mapping is from the name of the context to the context instance, and it is expected that any context in this map is referenced by at least one process group in this flow.")
    public Map<String, VersionedParameterContext> getParameterContexts() {
        return this.parameterContexts;
    }

    public void setParameterContexts(Map<String, VersionedParameterContext> parameterContexts) {
        this.parameterContexts = parameterContexts;
    }

    @ApiModelProperty(value="The optional encoding version of the flow contents.")
    public String getFlowEncodingVersion() {
        return this.flowEncodingVersion;
    }

    public void setFlowEncodingVersion(String flowEncodingVersion) {
        this.flowEncodingVersion = flowEncodingVersion;
    }

    @XmlTransient
    public boolean isLatest() {
        return this.flow != null && this.snapshotMetadata != null && this.flow.getVersionCount() == (long)this.getSnapshotMetadata().getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.snapshotMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedFlowSnapshot other = (VersionedFlowSnapshot)obj;
        return Objects.equals(this.snapshotMetadata, other.snapshotMetadata);
    }

    public String toString() {
        if (this.snapshotMetadata == null) {
            return "VersionedFlowSnapshot[flowContentsId=" + this.flowContents.getIdentifier() + ", flowContentsName=" + this.flowContents.getName() + ", NoMetadataAvailable]";
        }
        String flowName = this.flow == null ? "null" : this.flow.getName();
        return "VersionedFlowSnapshot[flowId=" + this.snapshotMetadata.getFlowIdentifier() + ", flowName=" + flowName + ", version=" + this.snapshotMetadata.getVersion() + ", comments=" + this.snapshotMetadata.getComments() + "]";
    }
}

