/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

public class User {
    private final String identifier;
    private final String identity;

    private User(Builder builder) {
        this.identifier = builder.identifier;
        this.identity = builder.identity;
        if (this.identifier == null || this.identifier.trim().isEmpty()) {
            throw new IllegalArgumentException("Identifier can not be null or empty");
        }
        if (this.identity == null || this.identity.trim().isEmpty()) {
            throw new IllegalArgumentException("Identity can not be null or empty");
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentity() {
        return this.identity;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }

    public String toString() {
        return String.format("identifier[%s], identity[%s]", this.getIdentifier(), this.getIdentity());
    }

    public static class Builder {
        private String identifier;
        private String identity;
        private final boolean fromUser;

        public Builder() {
            this.fromUser = false;
        }

        public Builder(User other) {
            if (other == null) {
                throw new IllegalArgumentException("Provided user can not be null");
            }
            this.identifier = other.getIdentifier();
            this.identity = other.getIdentity();
            this.fromUser = true;
        }

        public Builder identifier(String identifier) {
            if (this.fromUser) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing user");
            }
            this.identifier = identifier;
            return this;
        }

        public Builder identifierGenerateRandom() {
            if (this.fromUser) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing user");
            }
            this.identifier = UUID.randomUUID().toString();
            return this;
        }

        public Builder identifierGenerateFromSeed(String seed) {
            if (this.fromUser) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing user");
            }
            if (seed == null) {
                throw new IllegalArgumentException("Cannot seed the user identifier with a null value.");
            }
            this.identifier = UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).toString();
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

