/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.util.function.Consumer;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.springframework.security.saml2.provider.service.metadata.OpenSamlMetadataResolver;

public class EntityDescriptorCustomizer
implements Consumer<OpenSamlMetadataResolver.EntityDescriptorParameters> {
    private boolean wantAssertionsSigned;
    private boolean requestsSigned;

    public EntityDescriptorCustomizer(boolean wantAssertionsSigned, boolean requestsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
        this.requestsSigned = requestsSigned;
    }

    @Override
    public void accept(OpenSamlMetadataResolver.EntityDescriptorParameters entityDescriptorParameters) {
        EntityDescriptor entityDescriptor = entityDescriptorParameters.getEntityDescriptor();
        SPSSODescriptor spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        spssoDescriptor.setWantAssertionsSigned(Boolean.valueOf(this.wantAssertionsSigned));
        spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(this.requestsSigned));
    }
}

