/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.ReferenceResolver;
import org.apache.nifi.toolkit.cli.api.Referenceable;
import org.apache.nifi.toolkit.cli.api.ResolvedReference;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;

public class ParamContextsResult
extends AbstractWritableResult<ParameterContextsEntity>
implements Referenceable {
    private final ParameterContextsEntity parameterContexts;
    private final List<ParameterContextDTO> results;

    public ParamContextsResult(ResultType resultType, ParameterContextsEntity parameterContexts) {
        super(resultType);
        this.parameterContexts = Objects.requireNonNull(parameterContexts);
        this.results = new ArrayList<ParameterContextDTO>();
        Optional.ofNullable(parameterContexts.getParameterContexts()).orElse(Collections.emptySet()).forEach(pc -> {
            if (pc.getComponent() == null) {
                ParameterContextDTO dto = new ParameterContextDTO();
                dto.setId(pc.getId());
                dto.setName(pc.getId());
                this.results.add(dto);
            } else {
                this.results.add(pc.getComponent());
            }
        });
        Collections.sort(this.results, Comparator.comparing(ParameterContextDTO::getName));
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Table table = new Table.Builder().column("#", 3, 3, false).column("Id", 36, 36, false).column("Name", 20, 60, true).column("Inherited Param Contexts", 20, 60, true).column("Parameter Provider", 20, 60, false).column("Description", 40, 60, true).build();
        for (int i = 0; i < this.results.size(); ++i) {
            ParameterContextDTO r = this.results.get(i);
            String parameterProviderId = r.getParameterProviderConfiguration() == null ? "" : r.getParameterProviderConfiguration().getComponent().getParameterProviderId();
            String inheritedParamContexts = r.getInheritedParameterContexts() == null ? "" : r.getInheritedParameterContexts().stream().map(pc -> pc.getComponent().getName()).collect(Collectors.joining(", "));
            table.addRow("" + (i + 1), r.getId(), r.getName(), inheritedParamContexts, parameterProviderId, r.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ParameterContextsEntity getResult() {
        return this.parameterContexts;
    }

    @Override
    public ReferenceResolver createReferenceResolver(Context context) {
        final HashMap backRefs = new HashMap();
        AtomicInteger position = new AtomicInteger(0);
        this.results.forEach(pc -> backRefs.put(position.incrementAndGet(), pc));
        return new ReferenceResolver(){

            @Override
            public ResolvedReference resolve(CommandOption option, Integer position) {
                ParameterContextDTO parameterContext = (ParameterContextDTO)backRefs.get(position);
                if (parameterContext != null) {
                    return new ResolvedReference(option, position, parameterContext.getName(), parameterContext.getId());
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return backRefs.isEmpty();
            }
        };
    }
}

