/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.database;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.registry.security.authorization.AccessPolicy;
import org.apache.nifi.registry.security.authorization.util.AccessPolicyProviderUtils;

public class DatabaseAccessPolicyHolder {
    private final Set<AccessPolicy> allPolicies;
    private final Map<String, Set<AccessPolicy>> policiesByResource;
    private final Map<String, AccessPolicy> policiesById;

    public DatabaseAccessPolicyHolder(Set<AccessPolicy> allPolicies) {
        this.allPolicies = allPolicies;
        this.policiesByResource = Collections.unmodifiableMap(AccessPolicyProviderUtils.createResourcePolicyMap(allPolicies));
        this.policiesById = Collections.unmodifiableMap(AccessPolicyProviderUtils.createPoliciesByIdMap(allPolicies));
    }

    public Set<AccessPolicy> getAllPolicies() {
        return this.allPolicies;
    }

    public Map<String, Set<AccessPolicy>> getPoliciesByResource() {
        return this.policiesByResource;
    }

    public Map<String, AccessPolicy> getPoliciesById() {
        return this.policiesById;
    }
}

