/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.command;

import java.util.Objects;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.runtime.ManagementServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownCommand.class);
    private final NiFiServer applicationServer;
    private final ManagementServer managementServer;
    private final Runnable diagnosticsCommand;

    public ShutdownCommand(NiFiServer applicationServer, ManagementServer managementServer, Runnable diagnosticsCommand) {
        this.applicationServer = Objects.requireNonNull(applicationServer, "Application Server required");
        this.managementServer = Objects.requireNonNull(managementServer, "Management Server required");
        this.diagnosticsCommand = Objects.requireNonNull(diagnosticsCommand, "Diagnostics Command required");
    }

    @Override
    public void run() {
        logger.info("Application shutdown started");
        try {
            this.diagnosticsCommand.run();
        }
        catch (Throwable e) {
            logger.warn("Diagnostics Command failed", e);
        }
        try {
            this.managementServer.stop();
        }
        catch (Throwable e) {
            logger.warn("Management Server shutdown failed", e);
        }
        try {
            this.applicationServer.stop();
        }
        catch (Throwable e) {
            logger.warn("Application Server shutdown failed", e);
        }
        logger.info("Application shutdown completed");
    }
}

