/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.web.reactive;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.autoconfigure.ReactiveUserDetailsServiceAutoConfiguration;
import org.springframework.boot.security.autoconfigure.SecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={ReactiveUserDetailsServiceAutoConfiguration.class}, afterName={"org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration"})
@EnableConfigurationProperties(value={SecurityProperties.class})
@ConditionalOnClass(value={Flux.class, EnableWebFluxSecurity.class, WebFilterChainProxy.class, WebFluxConfigurer.class})
public final class ReactiveWebSecurityAutoConfiguration {

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Configuration(proxyBeanMethods=false)
    static class SpringBootWebFluxSecurityConfiguration {
        SpringBootWebFluxSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class, ReactiveUserDetailsService.class, SecurityWebFilterChain.class})
        ReactiveAuthenticationManager denyAllAuthenticationManager() {
            return authentication -> Mono.error((Throwable)new UsernameNotFoundException(authentication.getName()));
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnMissingBean(value={WebFilterChainProxy.class})
        @EnableWebFluxSecurity
        static class EnableWebFluxSecurityConfiguration {
            EnableWebFluxSecurityConfiguration() {
            }
        }
    }
}

