/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.archive.format.http.HttpHeader;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.io.RecoverableIOException;
import org.archive.util.LaxHttpParser;

public class HeaderedArchiveRecord
extends ArchiveRecord {
    private int contentHeadersLength = -1;
    private int statusCode = -1;
    private InputStream contentHeaderStream = null;
    private HttpHeader[] contentHeaders = null;

    public HeaderedArchiveRecord(ArchiveRecord ar) throws IOException {
        super(ar);
    }

    public HeaderedArchiveRecord(ArchiveRecord ar, boolean readContentHeader) throws IOException {
        super(ar);
        if (readContentHeader) {
            this.contentHeaderStream = this.readContentHeaders();
        }
    }

    public void skipHttpHeader() throws IOException {
        if (this.contentHeaderStream == null) {
            return;
        }
        int available = this.contentHeaderStream.available();
        while (this.contentHeaderStream != null && (available = this.contentHeaderStream.available()) > 0) {
            byte[] buffer = new byte[available];
            this.read(buffer, 0, available);
        }
    }

    public void dumpHttpHeader() throws IOException {
        this.dumpHttpHeader(System.out);
    }

    public void dumpHttpHeader(PrintStream stream) throws IOException {
        if (this.contentHeaderStream == null) {
            return;
        }
        int available = this.contentHeaderStream.available();
        while (this.contentHeaderStream != null && (available = this.contentHeaderStream.available()) > 0) {
            byte[] buffer = new byte[available];
            int read = this.read(buffer, 0, available);
            stream.write(buffer, 0, read);
        }
    }

    private InputStream readContentHeaders() throws IOException {
        if (!this.hasContentHeaders()) {
            return null;
        }
        byte[] statusBytes = LaxHttpParser.readRawLine(this.getIn());
        int eolCharCount = this.getEolCharsCount(statusBytes);
        if (eolCharCount <= 0) {
            throw new IOException("Failed to read raw lie where one  was expected: " + new String(statusBytes, "ISO-8859-1"));
        }
        String statusLine = new String(statusBytes, 0, statusBytes.length - eolCharCount, "ISO-8859-1");
        statusLine = statusLine.trim();
        boolean isHttpResponse = statusLine.startsWith("HTTP");
        boolean isHttpRequest = false;
        if (!isHttpResponse) {
            boolean bl = isHttpRequest = statusLine.toUpperCase(Locale.ROOT).startsWith("GET") || !statusLine.toUpperCase(Locale.ROOT).startsWith("POST");
        }
        if (!isHttpResponse && !isHttpRequest) {
            throw new UnexpectedStartLineIOException("Failed parse of status line: " + statusLine);
        }
        this.statusCode = isHttpResponse ? HeaderedArchiveRecord.parseStatusCode(statusLine) : -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(statusBytes.length + 4096);
        baos.write(statusBytes);
        byte[] lineBytes = null;
        do {
            if ((eolCharCount = this.getEolCharsCount(lineBytes = LaxHttpParser.readRawLine(this.getIn()))) <= 0) {
                throw new IOException("Failed reading headers: " + (lineBytes != null ? new String(lineBytes, StandardCharsets.ISO_8859_1) : null));
            }
            baos.write(lineBytes);
        } while (lineBytes.length - eolCharCount > 0);
        byte[] headerBytes = baos.toByteArray();
        this.contentHeadersLength = headerBytes.length;
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        if (!bais.markSupported()) {
            throw new IOException("ByteArrayInputStream does not support mark");
        }
        bais.mark(headerBytes.length);
        bais.read(statusBytes, 0, statusBytes.length);
        this.contentHeaders = LaxHttpParser.parseHeaders(bais, "ISO-8859-1");
        bais.reset();
        return bais;
    }

    public static int parseStatusCode(String statusLine) {
        int i = statusLine.indexOf(32);
        if (i < 0) {
            return -1;
        }
        int j = statusLine.indexOf(32, i + 1);
        if (j < 0) {
            j = statusLine.length();
        }
        try {
            return Integer.parseInt(statusLine.substring(i + 1, j));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private int getEolCharsCount(byte[] bytes) {
        int count = 0;
        if (bytes != null && bytes.length >= 1 && bytes[bytes.length - 1] == 10) {
            ++count;
            if (bytes.length >= 2 && bytes[bytes.length - 2] == 13) {
                ++count;
            }
        }
        return count;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getContentHeadersLength() {
        return this.contentHeadersLength;
    }

    public HttpHeader[] getContentHeaders() {
        return this.contentHeaders;
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        if (this.contentHeaderStream != null && this.contentHeaderStream.available() > 0) {
            c = this.contentHeaderStream.read();
            if (this.contentHeaderStream.available() <= 0) {
                this.contentHeaderStream = null;
            }
        } else {
            c = super.read();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int read = -1;
        if (this.contentHeaderStream != null && this.contentHeaderStream.available() > 0) {
            read = Math.min(length, this.contentHeaderStream.available());
            read = read == 0 ? -1 : this.contentHeaderStream.read(b, offset, read);
            if (this.contentHeaderStream.available() <= 0) {
                this.contentHeaderStream = null;
            }
        } else {
            read = super.read(b, offset, length);
        }
        return read;
    }

    @Override
    public int available() {
        return ((ArchiveRecord)this.in).available();
    }

    @Override
    public void close() throws IOException {
        ((ArchiveRecord)this.in).close();
    }

    @Override
    public void dump() throws IOException {
        ((ArchiveRecord)this.in).dump();
    }

    @Override
    public void dump(OutputStream os) throws IOException {
        ((ArchiveRecord)this.in).dump(os);
    }

    @Override
    protected String getDigest4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getDigest4Cdx(h);
    }

    @Override
    public String getDigestStr() {
        return ((ArchiveRecord)this.in).getDigestStr();
    }

    @Override
    public ArchiveRecordHeader getHeader() {
        return ((ArchiveRecord)this.in).getHeader();
    }

    @Override
    protected String getIp4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getIp4Cdx(h);
    }

    @Override
    protected String getMimetype4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getMimetype4Cdx(h);
    }

    @Override
    public long getPosition() {
        return ((ArchiveRecord)this.in).getPosition();
    }

    @Override
    protected String getStatusCode4Cdx(ArchiveRecordHeader h) {
        return ((ArchiveRecord)this.in).getStatusCode4Cdx(h);
    }

    @Override
    public boolean hasContentHeaders() {
        return ((ArchiveRecord)this.in).hasContentHeaders();
    }

    @Override
    protected void incrementPosition() {
        ((ArchiveRecord)this.in).incrementPosition();
    }

    @Override
    protected void incrementPosition(long incr) {
        ((ArchiveRecord)this.in).incrementPosition(incr);
    }

    @Override
    protected boolean isEor() {
        return ((ArchiveRecord)this.in).isEor();
    }

    @Override
    public boolean isStrict() {
        return ((ArchiveRecord)this.in).isStrict();
    }

    @Override
    public boolean markSupported() {
        return ((ArchiveRecord)this.in).markSupported();
    }

    @Override
    protected String outputCdx(String strippedFileName) throws IOException {
        return ((ArchiveRecord)this.in).outputCdx(strippedFileName);
    }

    @Override
    protected void setEor(boolean eor) {
        ((ArchiveRecord)this.in).setEor(eor);
    }

    @Override
    protected void setHeader(ArchiveRecordHeader header) {
        ((ArchiveRecord)this.in).setHeader(header);
    }

    @Override
    public void setStrict(boolean strict) {
        ((ArchiveRecord)this.in).setStrict(strict);
    }

    @Override
    protected void skip() throws IOException {
        ((ArchiveRecord)this.in).skip();
    }

    @Override
    public long skip(long n) throws IOException {
        return ((ArchiveRecord)this.in).skip(n);
    }

    public static class UnexpectedStartLineIOException
    extends RecoverableIOException {
        private static final long serialVersionUID = 1L;

        public UnexpectedStartLineIOException(String reason) {
            super(reason);
        }
    }
}

