/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainStatistics
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Text FETCHED_TEXT = new Text("FETCHED");
    private static final Text NOT_FETCHED_TEXT = new Text("NOT_FETCHED");
    private static final int MODE_HOST = 1;
    private static final int MODE_DOMAIN = 2;
    private static final int MODE_SUFFIX = 3;
    private static final int MODE_TLD = 4;

    public int run(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: DomainStatistics inputDirs outDir mode [numOfReducer]");
            System.err.println("\tinputDirs\tComma separated list of crawldb input directories");
            System.err.println("\t\t\tE.g.: crawl/crawldb/");
            System.err.println("\toutDir\t\tOutput directory where results should be dumped");
            System.err.println("\tmode\t\tSet statistics gathering mode");
            System.err.println("\t\t\t\thost\tGather statistics by host");
            System.err.println("\t\t\t\tdomain\tGather statistics by domain");
            System.err.println("\t\t\t\tsuffix\tGather statistics by suffix");
            System.err.println("\t\t\t\ttld\tGather statistics by top level directory");
            System.err.println("\t[numOfReducers]\tOptional number of reduce jobs to use. Defaults to 1.");
            return 1;
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 3) {
            numOfReducers = Integer.parseInt(args[3]);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("DomainStatistics: starting");
        int mode = 0;
        Object jobName = "Nutch DomainStatistics: ";
        if (args[2].equals("host")) {
            jobName = (String)jobName + "Host statistics";
            mode = 1;
        } else if (args[2].equals("domain")) {
            jobName = (String)jobName + "Domain statistics";
            mode = 2;
        } else if (args[2].equals("suffix")) {
            jobName = (String)jobName + "Suffix statistics";
            mode = 3;
        } else if (args[2].equals("tld")) {
            jobName = (String)jobName + "Top Level Directory statistics";
            mode = 4;
        }
        Configuration conf = this.getConf();
        conf.setInt("domain.statistics.mode", mode);
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
        Job job = Job.getInstance((Configuration)conf, (String)jobName);
        job.setJarByClass(DomainStatistics.class);
        String[] inputDirsSpecs = inputDir.split(",");
        for (int i = 0; i < inputDirsSpecs.length; ++i) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputDirsSpecs[i], "current"));
        }
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(DomainStatisticsMapper.class);
        job.setReducerClass(DomainStatisticsReducer.class);
        job.setCombinerClass(DomainStatisticsCombiner.class);
        job.setNumReduceTasks(numOfReducers);
        try {
            boolean success = job.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("Injector", job);
                LOG.error(message);
                throw new RuntimeException(message);
            }
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("{} job failed", jobName, (Object)e);
            throw e;
        }
        stopWatch.stop();
        LOG.info("DomainStatistics: finished, elapsed: {} ms ", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new DomainStatistics(), (String[])args);
    }

    public static class DomainStatisticsCombiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)key, (Object)new LongWritable(total));
        }
    }

    static class DomainStatisticsReducer
    extends Reducer<Text, LongWritable, LongWritable, Text> {
        DomainStatisticsReducer() {
        }

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)new LongWritable(total), (Object)key);
        }
    }

    static class DomainStatisticsMapper
    extends Mapper<Text, CrawlDatum, Text, LongWritable> {
        int mode = 0;
        private Counter fetchedCounter;
        private Counter notFetchedCounter;
        private Counter emptyResultCounter;

        DomainStatisticsMapper() {
        }

        public void setup(Mapper.Context context) {
            this.mode = context.getConfiguration().getInt("domain.statistics.mode", 2);
            this.initCounters(context);
        }

        private void initCounters(Mapper.Context context) {
            this.fetchedCounter = context.getCounter("nutch_domain_stats", "fetched_total");
            this.notFetchedCounter = context.getCounter("nutch_domain_stats", "not_fetched_total");
            this.emptyResultCounter = context.getCounter("nutch_domain_stats", "empty_result_total");
        }

        public void map(Text urlText, CrawlDatum datum, Mapper.Context context) throws IOException, InterruptedException {
            if (datum.getStatus() == 2 || datum.getStatus() == 6) {
                try {
                    URL url;
                    try {
                        url = new URL(urlText.toString());
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Failed to get host or domain from URL {}: {}", (Object)urlText, (Object)e.getMessage());
                        return;
                    }
                    String out = null;
                    switch (this.mode) {
                        case 1: {
                            out = url.getHost();
                            break;
                        }
                        case 2: {
                            out = URLUtil.getDomainName(url);
                            break;
                        }
                        case 3: {
                            out = URLUtil.getDomainSuffix(url);
                            break;
                        }
                        case 4: {
                            out = URLUtil.getTopLevelDomainName(url);
                        }
                    }
                    if (out.trim().equals("")) {
                        LOG.info("url : {}", (Object)url);
                        this.emptyResultCounter.increment(1L);
                    }
                    context.write((Object)new Text(out), (Object)new LongWritable(1L));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fetchedCounter.increment(1L);
                context.write((Object)FETCHED_TEXT, (Object)new LongWritable(1L));
            } else {
                this.notFetchedCounter.increment(1L);
                context.write((Object)NOT_FETCHED_TEXT, (Object)new LongWritable(1L));
            }
        }
    }
}

