/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.remote.Browser;

@AutoService(value={WebDriverInfo.class})
public class ChromeDriverInfo
extends ChromiumDriverInfo {
    public String getDisplayName() {
        return "Chrome";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)Browser.CHROME.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        return Browser.CHROME.is(capabilities) || capabilities.getCapability("goog:chromeOptions") != null;
    }

    public boolean isSupportingCdp() {
        return true;
    }

    public boolean isSupportingBiDi() {
        return false;
    }

    public boolean isAvailable() {
        try {
            ChromeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(new ChromeOptions().merge(capabilities));
        return Optional.of(driver);
    }
}

