/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.internal.SearchContext;

public abstract class DeferableBucketAggregator
extends BucketsAggregator {
    private DeferringBucketCollector recordingWrapper;
    private List<String> deferredAggregationNames;

    protected DeferableBucketAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
    }

    @Override
    protected void doPreCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>(this.subAggregators.length);
        ArrayList<Aggregator> deferredAggregations = null;
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.recordingWrapper == null) {
                    this.recordingWrapper = this.getDeferringCollector();
                    deferredAggregations = new ArrayList<Aggregator>(this.subAggregators.length);
                    this.deferredAggregationNames = new ArrayList<String>(this.subAggregators.length);
                }
                deferredAggregations.add(this.subAggregators[i]);
                this.deferredAggregationNames.add(this.subAggregators[i].name());
                this.subAggregators[i] = this.recordingWrapper.wrap(this.subAggregators[i]);
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.recordingWrapper != null) {
            this.recordingWrapper.setDeferredCollector(deferredAggregations);
            collectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = MultiBucketCollector.wrap(collectors);
    }

    public DeferringBucketCollector getDeferringCollector() {
        return new BestBucketsDeferringCollector(this.context(), DeferableBucketAggregator.descendsFromGlobalAggregator(this.parent()));
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    @Override
    protected void beforeBuildingBuckets(long[] ordsToCollect) throws IOException {
        if (this.recordingWrapper != null) {
            this.recordingWrapper.prepareSelectedBuckets(ordsToCollect);
        }
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        if (this.deferredAggregationNames != null) {
            add.accept("deferred_aggregators", this.deferredAggregationNames);
        }
        super.collectDebugInfo(add);
    }
}

