/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class ServiceDocumentResponse
extends ServiceResponse {
    private final ODataSerializer serializer;
    private final ContentType responseContentType;

    public static ServiceDocumentResponse getInstace(ServiceRequest request, ODataResponse respose, ContentType responseContentType) throws ContentNegotiatorException, SerializerException {
        return new ServiceDocumentResponse(request.getServiceMetaData(), respose, request.getSerializer(), responseContentType, request.getPreferences());
    }

    private ServiceDocumentResponse(ServiceMetadata metadata, ODataResponse respose, ODataSerializer serializer, ContentType responseContentType, Map<String, String> preferences) {
        super(metadata, respose, preferences);
        this.serializer = serializer;
        this.responseContentType = responseContentType;
    }

    public void writeServiceDocument(String serviceRoot) throws ODataLibraryException {
        assert (!this.isClosed());
        this.response.setContent(this.serializer.serviceDocument(this.metadata, serviceRoot).getContent());
        this.writeOK(this.responseContentType);
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeError(ODataServerError error) {
        try {
            this.writeHeader("Content-Type", this.responseContentType.toContentTypeString());
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }
}

