/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Optional;
import org.netpreserve.jwarc.GeminiResponse;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;

public class WarcResponse
extends WarcCaptureRecord {
    private HttpResponse http;
    private GeminiResponse gemini;

    WarcResponse(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public HttpResponse http() throws IOException {
        if (this.http == null) {
            MessageBody body = this.body();
            if (body.position() != 0L) {
                throw new IllegalStateException("http() cannot be called after reading from body");
            }
            try {
                if (body instanceof LengthedBody) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    LengthedBody lengthed = (LengthedBody)body;
                    this.http = HttpResponse.parse(lengthed.discardPushbackOnRead(), Channels.newChannel(baos));
                    lengthed.pushback(baos.toByteArray());
                } else {
                    this.http = HttpResponse.parse(body);
                }
            }
            catch (ParsingException e) {
                e.recordSource = this.recordSource;
                throw e;
            }
        }
        return this.http;
    }

    public GeminiResponse gemini() throws IOException {
        if (this.gemini == null) {
            MessageBody body = this.body();
            if (body.position() != 0L) {
                throw new IllegalStateException("gemini() cannot be called after reading from body");
            }
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            buffer.flip();
            try {
                this.gemini = GeminiResponse.parse(body, buffer);
            }
            catch (ParsingException e) {
                e.recordSource = this.recordSource;
                throw e;
            }
            if (body instanceof LengthedBody) {
                ((LengthedBody)body).pushback(this.gemini.serializeHeader());
            }
        }
        return this.gemini;
    }

    @Override
    public MediaType payloadType() throws IOException {
        return this.payload().map(WarcPayload::type).orElse(MediaType.OCTET_STREAM);
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        if (this.contentType().base().equals(MediaType.HTTP)) {
            return Optional.of(new WarcPayload(this.http().body()){

                @Override
                public MediaType type() {
                    return WarcResponse.this.http.contentType();
                }

                @Override
                Optional<MediaType> identifiedType() {
                    return WarcResponse.this.identifiedPayloadType();
                }

                @Override
                public Optional<WarcDigest> digest() {
                    return WarcResponse.this.payloadDigest();
                }
            });
        }
        if (this.contentType().base().equals(MediaType.GEMINI)) {
            return Optional.of(new WarcPayload(this.gemini().body()){

                @Override
                public MediaType type() {
                    return WarcResponse.this.gemini.contentType();
                }

                @Override
                Optional<MediaType> identifiedType() {
                    return WarcResponse.this.identifiedPayloadType();
                }

                @Override
                public Optional<WarcDigest> digest() {
                    return WarcResponse.this.payloadDigest();
                }
            });
        }
        return Optional.empty();
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcResponse, Builder> {
        public Builder(URI targetURI) {
            this(targetURI.toString());
        }

        public Builder(String targetURI) {
            super("response");
            this.setHeader("WARC-Target-URI", targetURI);
        }

        public Builder body(HttpResponse httpResponse) throws IOException {
            return (Builder)this.body(MediaType.HTTP_RESPONSE, httpResponse);
        }

        @Override
        public WarcResponse build() {
            return this.build(WarcResponse::new);
        }
    }
}

