/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.INotificationMessage;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Alert;
import java.io.Serializable;
import java.time.Duration;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NotificationAlert
extends Alert {
    private static final long serialVersionUID = 1L;
    private final IModel<INotificationMessage> notificationModel;
    private final Duration duration;

    public NotificationAlert(String markupId, FeedbackMessage message) {
        this(markupId, message, Duration.ZERO);
    }

    public NotificationAlert(String markupId, FeedbackMessage message, Duration duration) {
        super(markupId, (IModel<String>)Model.of((Serializable)((Object)"")));
        this.duration = duration;
        this.notificationModel = Model.of();
        this.type(Alert.Type.from(message.getLevelAsString()));
        if (message.getMessage() instanceof INotificationMessage) {
            this.withNotificationMessage((INotificationMessage)((Object)message.getMessage()));
        } else {
            this.withMessage((IModel<String>)Model.of((Serializable)((Object)String.valueOf(message.getMessage()))));
            this.hideAfter(duration);
        }
    }

    private NotificationAlert withNotificationMessage(INotificationMessage notificationMessage) {
        this.notificationModel.setObject((Object)notificationMessage);
        this.hideAfter(notificationMessage.hideAfter() == null ? this.duration : notificationMessage.hideAfter());
        this.useInlineHeader(notificationMessage.inlineHeader());
        this.withHeader(notificationMessage.header());
        this.withMessage(notificationMessage.message());
        this.getMessage().setEscapeModelStrings(notificationMessage.escapeModelStrings());
        return this;
    }

    public void detachModels() {
        super.detachModels();
        this.notificationModel.detach();
    }
}

