/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketstuff.dashboard.DashboardContextInitializer;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetAction;

public class WidgetActionsPanel
extends GenericPanel<Widget> {
    private static final long serialVersionUID = 1L;

    public WidgetActionsPanel(String id, IModel<Widget> model) {
        super(id, model);
        LoadableDetachableModel<List<WidgetAction>> actionsModel = new LoadableDetachableModel<List<WidgetAction>>(){
            private static final long serialVersionUID = 1L;

            protected List<WidgetAction> load() {
                return DashboardContextInitializer.getDashboardContext().getWidgetActionsFactory().createWidgetActions(WidgetActionsPanel.this.getWidget());
            }
        };
        ListView<WidgetAction> actionsView = new ListView<WidgetAction>("action", (IModel)actionsModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<WidgetAction> item) {
                WidgetAction action = (WidgetAction)item.getModelObject();
                AbstractLink link = action.getLink("link");
                link.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)action.getCssClass()))});
                link.add(new Behavior[]{AttributeModifier.replace((String)"title", action.getTooltip())});
                item.add(new Component[]{link});
            }
        };
        this.add(new Component[]{actionsView});
    }

    private Widget getWidget() {
        return (Widget)this.getModelObject();
    }
}

