/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.RestCallExecution;
import com.hazelcast.internal.util.counters.MwCounter;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class RestCallCollector {
    public static final int SET_SIZE_LIMIT = 1000;
    private final MwCounter mapPostSuccCount = MwCounter.newMwCounter();
    private final MwCounter mapPostFailCount = MwCounter.newMwCounter();
    private final MwCounter mapGetSuccCount = MwCounter.newMwCounter();
    private final MwCounter mapGetFailCount = MwCounter.newMwCounter();
    private final MwCounter mapDeleteSuccCount = MwCounter.newMwCounter();
    private final MwCounter mapDeleteFailCount = MwCounter.newMwCounter();
    private final MwCounter mapTotalRequestCount = MwCounter.newMwCounter();
    private final MwCounter queuePostSuccCount = MwCounter.newMwCounter();
    private final MwCounter queuePostFailCount = MwCounter.newMwCounter();
    private final MwCounter queueGetSuccCount = MwCounter.newMwCounter();
    private final MwCounter queueGetFailCount = MwCounter.newMwCounter();
    private final MwCounter queueDeleteSuccCount = MwCounter.newMwCounter();
    private final MwCounter queueDeleteFailCount = MwCounter.newMwCounter();
    private final MwCounter queueTotalRequestCount = MwCounter.newMwCounter();
    private final MwCounter configUpdateSuccCount = MwCounter.newMwCounter();
    private final MwCounter configUpdateFailCount = MwCounter.newMwCounter();
    private final MwCounter configReloadSuccCount = MwCounter.newMwCounter();
    private final MwCounter configReloadFailCount = MwCounter.newMwCounter();
    private final MwCounter requestCount = MwCounter.newMwCounter();
    private final ConcurrentHashMap.KeySetView<RequestIdentifier, Boolean> uniqueRequests = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap.KeySetView<String, Boolean> accessedMaps = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap.KeySetView<String, Boolean> accessedQueues = ConcurrentHashMap.newKeySet();

    void collectExecution(HttpCommand command) {
        RestCallExecution execution = command.getExecutionDetails();
        TextCommandConstants.TextCommandType type = command.getType();
        this.updateRequestCounters(type, execution);
        String objectName = execution.getObjectName();
        this.updateAccessedObjectSets(execution, objectName);
        switch (type) {
            case HTTP_POST: {
                this.handlePost(execution);
                break;
            }
            case HTTP_GET: {
                this.handleGet(execution);
                break;
            }
            case HTTP_DELETE: {
                this.handleDelete(execution);
                break;
            }
        }
    }

    private void handleDelete(RestCallExecution execution) {
        RestCallExecution.ObjectType objectType = execution.getObjectType();
        if (objectType == null) {
            return;
        }
        switch (objectType) {
            case MAP: {
                (execution.isSuccess() ? this.mapDeleteSuccCount : this.mapDeleteFailCount).inc();
                break;
            }
            case QUEUE: {
                (execution.isSuccess() ? this.queueDeleteSuccCount : this.queueDeleteFailCount).inc();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + objectType);
            }
        }
    }

    private void handleGet(RestCallExecution execution) {
        RestCallExecution.ObjectType objectType = execution.getObjectType();
        if (objectType == null) {
            return;
        }
        switch (objectType) {
            case MAP: {
                (execution.isSuccess() ? this.mapGetSuccCount : this.mapGetFailCount).inc();
                break;
            }
            case QUEUE: {
                (execution.isSuccess() ? this.queueGetSuccCount : this.queueGetFailCount).inc();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + execution.getObjectType());
            }
        }
    }

    private void handlePost(RestCallExecution execution) {
        RestCallExecution.ObjectType objectType = execution.getObjectType();
        if (objectType == null) {
            if (execution.getRequestPath().endsWith("/hazelcast/rest/config/update")) {
                (execution.isSuccess() ? this.configUpdateSuccCount : this.configUpdateFailCount).inc();
            } else if (execution.getRequestPath().endsWith("/hazelcast/rest/config/reload")) {
                (execution.isSuccess() ? this.configReloadSuccCount : this.configReloadFailCount).inc();
            }
            return;
        }
        switch (objectType) {
            case MAP: {
                (execution.isSuccess() ? this.mapPostSuccCount : this.mapPostFailCount).inc();
                break;
            }
            case QUEUE: {
                (execution.isSuccess() ? this.queuePostSuccCount : this.queuePostFailCount).inc();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + execution.getObjectType());
            }
        }
    }

    private void updateAccessedObjectSets(RestCallExecution execution, String objectName) {
        if (objectName == null) {
            return;
        }
        RestCallExecution.ObjectType objectType = execution.getObjectType();
        if (objectType == null) {
            return;
        }
        switch (objectType) {
            case MAP: {
                this.accessedMaps.add(objectName);
                break;
            }
            case QUEUE: {
                this.accessedQueues.add(objectName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + objectType);
            }
        }
    }

    private void updateRequestCounters(TextCommandConstants.TextCommandType type, RestCallExecution execution) {
        if (this.uniqueRequests.size() < 1000) {
            this.uniqueRequests.add(new RequestIdentifier(type, execution.getRequestPath()));
        }
        this.requestCount.inc();
        RestCallExecution.ObjectType objectType = execution.getObjectType();
        if (objectType == null) {
            return;
        }
        switch (objectType) {
            case MAP: {
                this.mapTotalRequestCount.inc();
                break;
            }
            case QUEUE: {
                this.queueTotalRequestCount.inc();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + objectType);
            }
        }
    }

    public String getMapPostSuccessCount() {
        return String.valueOf(this.mapPostSuccCount.get());
    }

    public String getMapPostFailureCount() {
        return String.valueOf(this.mapPostFailCount.get());
    }

    public String getRequestCount() {
        return String.valueOf(this.requestCount.get());
    }

    public String getUniqueRequestCount() {
        return String.valueOf(this.uniqueRequests.size());
    }

    public String getMapGetSuccessCount() {
        return String.valueOf(this.mapGetSuccCount.get());
    }

    public String getMapGetFailureCount() {
        return String.valueOf(this.mapGetFailCount.get());
    }

    public String getQueuePostSuccessCount() {
        return String.valueOf(this.queuePostSuccCount.get());
    }

    public String getQueuePostFailureCount() {
        return String.valueOf(this.queuePostFailCount.get());
    }

    public String getQueueGetSuccessCount() {
        return String.valueOf(this.queueGetSuccCount.get());
    }

    public String getQueueGetFailureCount() {
        return String.valueOf(this.queueGetFailCount.get());
    }

    public String getQueueDeleteSuccessCount() {
        return String.valueOf(this.queueDeleteSuccCount.get());
    }

    public String getQueueDeleteFailureCount() {
        return String.valueOf(this.queueDeleteFailCount.get());
    }

    public String getAccessedMapCount() {
        return String.valueOf(this.accessedMaps.size());
    }

    public String getAccessedQueueCount() {
        return String.valueOf(this.accessedQueues.size());
    }

    public String getMapDeleteSuccessCount() {
        return String.valueOf(this.mapDeleteSuccCount.get());
    }

    public String getMapDeleteFailureCount() {
        return String.valueOf(this.mapDeleteFailCount.get());
    }

    public String getTotalMapRequestCount() {
        return String.valueOf(this.mapTotalRequestCount.get());
    }

    public String getConfigUpdateSuccessCount() {
        return String.valueOf(this.configUpdateSuccCount.get());
    }

    public String getConfigUpdateFailureCount() {
        return String.valueOf(this.configUpdateFailCount.get());
    }

    public String getConfigReloadSuccessCount() {
        return String.valueOf(this.configReloadSuccCount.get());
    }

    public String getConfigReloadFailureCount() {
        return String.valueOf(this.configReloadFailCount.get());
    }

    public String getTotalQueueRequestCount() {
        return String.valueOf(this.queueTotalRequestCount.get());
    }

    private static class RequestIdentifier {
        private final TextCommandConstants.TextCommandType method;
        private final String path;

        RequestIdentifier(TextCommandConstants.TextCommandType method, String path) {
            this.method = method;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestIdentifier that = (RequestIdentifier)o;
            return this.method.equals((Object)that.method) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.method, this.path});
        }

        public String getPath() {
            return this.path;
        }
    }
}

