/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.langdetect.LanguageDetectorEvaluationErrorListener;
import opennlp.tools.cmdline.langdetect.LanguageDetectorFineGrainedReportListener;
import opennlp.tools.cmdline.langdetect.LanguageDetectorModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorEvaluator;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectorEvaluatorTool
extends AbstractEvaluatorTool<LanguageSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(LanguageDetectorEvaluatorTool.class);

    public LanguageDetectorEvaluatorTool() {
        super(LanguageSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Language Detector model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        LanguageDetectorModel model = (LanguageDetectorModel)new LanguageDetectorModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new LanguageDetectorEvaluationErrorListener());
        }
        LanguageDetectorFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new LanguageDetectorFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating LanguageDetector fine-grained report file: " + e.getMessage());
            }
        }
        LanguageDetectorEvaluator evaluator = new LanguageDetectorEvaluator((LanguageDetector)new LanguageDetectorME(model), listeners.toArray(new LanguageDetectorEvaluationMonitor[0]));
        final PerformanceMonitor monitor = new PerformanceMonitor("doc");
        try (ObjectStream<LanguageSample> measuredSampleStream = new ObjectStream<LanguageSample>(){

            public LanguageSample read() throws IOException {
                monitor.incrementCounter();
                return (LanguageSample)LanguageDetectorEvaluatorTool.this.sampleStream.read();
            }

            public void reset() throws IOException {
                LanguageDetectorEvaluatorTool.this.sampleStream.reset();
            }

            public void close() throws IOException {
                LanguageDetectorEvaluatorTool.this.sampleStream.close();
            }
        };){
            monitor.startAndPrintThroughput();
            evaluator.evaluate((ObjectStream)measuredSampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), (Throwable)e);
        }
        monitor.stopAndPrintFinalResult();
        logger.info(evaluator.toString());
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                reportOutputStream.flush();
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
    }
}

