/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenizerMEEvaluatorTool
extends AbstractEvaluatorTool<TokenSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(TokenizerMEEvaluatorTool.class);

    public TokenizerMEEvaluatorTool() {
        super(TokenSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the learnable tokenizer";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        TokenizerModel model = (TokenizerModel)new TokenizerModelLoader().load(((EvalToolParams)this.params).getModel());
        TokenEvaluationErrorListener misclassifiedListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            misclassifiedListener = new TokenEvaluationErrorListener();
        }
        TokenizerEvaluator evaluator = new TokenizerEvaluator((Tokenizer)new TokenizerME(model), new TokenizerEvaluationMonitor[]{misclassifiedListener});
        logger.info("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        logger.info(evaluator.getFMeasure().toString());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

