/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public abstract class BaseToolFactory {
    protected ArtifactProvider artifactProvider;

    protected void init(ArtifactProvider artifactProvider) {
        this.artifactProvider = artifactProvider;
    }

    public Map<String, ArtifactSerializer<?>> createArtifactSerializersMap() {
        return new HashMap();
    }

    public Map<String, Object> createArtifactMap() {
        return new HashMap<String, Object>();
    }

    public Map<String, String> createManifestEntries() {
        return new HashMap<String, String>();
    }

    public abstract void validateArtifactMap() throws InvalidFormatException;

    public static BaseToolFactory create(String subclassName, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory theFactory;
        try {
            theFactory = (BaseToolFactory)ExtensionLoader.instantiateExtension(BaseToolFactory.class, (String)subclassName);
            if (theFactory != null) {
                theFactory.init(artifactProvider);
            }
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization threw an exception.";
            throw new InvalidFormatException(msg, (Throwable)e);
        }
        return theFactory;
    }

    public static BaseToolFactory create(Class<? extends BaseToolFactory> factoryClass, ArtifactProvider artifactProvider) throws InvalidFormatException {
        BaseToolFactory theFactory = null;
        if (factoryClass != null) {
            try {
                theFactory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                theFactory.init(artifactProvider);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + factoryClass.getCanonicalName() + ". The initialization threw an exception.";
                throw new InvalidFormatException(msg, (Throwable)e);
            }
        }
        return theFactory;
    }
}

