/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.WordVector;
import opennlp.tools.util.wordvector.WordVectorType;

class FloatArrayVector
implements WordVector {
    private final float[] vector;

    FloatArrayVector(float[] vector) {
        this.vector = vector;
    }

    public WordVectorType getDataType() {
        return WordVectorType.FLOAT;
    }

    public float getAsFloat(int index) {
        return this.vector[index];
    }

    public double getAsDouble(int index) {
        return this.getAsFloat(index);
    }

    public FloatBuffer toFloatBuffer() {
        return FloatBuffer.wrap(this.vector).asReadOnlyBuffer();
    }

    public DoubleBuffer toDoubleBuffer() {
        double[] doubleVector = new double[this.vector.length];
        for (int i = 0; i < doubleVector.length; ++i) {
            doubleVector[i] = this.vector[i];
        }
        return DoubleBuffer.wrap(doubleVector).asReadOnlyBuffer();
    }

    public int dimension() {
        return this.vector.length;
    }
}

