/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.text.PDTextState;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamEngine;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.GlyphException;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentStreamWrapper
extends ContentStreamEngine {
    public ContentStreamWrapper(PreflightContext _context, PDPage _page) {
        super(_context, _page);
    }

    public void validPageContentStream() throws ValidationException {
        try {
            PDStream pstream = this.processeedPage.getContents();
            if (pstream != null) {
                this.processStream(this.processeedPage, this.processeedPage.findResources(), pstream.getStream());
            }
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the ContentStream : " + e.getMessage(), e);
        }
    }

    public void validXObjContentStream(PDXObjectForm xobj) throws ValidationException {
        try {
            this.resetEnginContext();
            PDResources resources = xobj.getResources();
            if (resources == null) {
                resources = new PDResources();
            }
            this.processSubStream(this.processeedPage, resources, xobj.getCOSStream());
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the ContentStream : " + e.getMessage(), e);
        }
    }

    public void validPatternContentStream(COSStream pattern) throws ValidationException {
        try {
            COSDictionary res = (COSDictionary)pattern.getDictionaryObject(COSName.RESOURCES);
            this.resetEnginContext();
            this.processSubStream(this.processeedPage, new PDResources(res), pattern);
        }
        catch (ContentStreamException e) {
            this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check the ContentStream : " + e.getMessage(), e);
        }
    }

    public final void resetEnginContext() {
        this.setGraphicsState(new PDGraphicsState());
        this.setTextMatrix(null);
        this.setTextLineMatrix(null);
        this.getGraphicsStack().clear();
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        String operation = operator.getOperation();
        OperatorProcessor processor = (OperatorProcessor)this.contentStreamEngineOperators.get(operation);
        if (processor == null) {
            this.registerError("The operator \"" + operation + "\" isn't supported.", "1.2.10");
            return;
        }
        processor.setContext(this);
        processor.process(operator, arguments);
        if ("BI".equals(operation)) {
            this.validImageFilter(operator);
            this.validImageColorSpace(operator);
        }
        this.checkShowTextOperators(operator, arguments);
        this.checkColorOperators(operation);
        this.validRenderingIntent(operator, arguments);
        this.checkSetColorSpaceOperators(operator, arguments);
        this.validNumberOfGraphicStates(operator);
    }

    protected void checkShowTextOperators(PDFOperator operator, List<?> arguments) throws ContentStreamException, IOException {
        String op = operator.getOperation();
        if ("Tj".equals(op) || "'".equals(op) || "\"".equals(op)) {
            this.validStringDefinition(operator, arguments);
        }
        if ("TJ".equals(op)) {
            this.validStringArray(operator, arguments);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validStringDefinition(PDFOperator operator, List<?> arguments) throws ContentStreamException, IOException {
        if ("\"".equals(operator.getOperation())) {
            if (arguments.size() != 3) {
                this.registerError("Invalid argument for the operator : " + operator.getOperation(), "1.2.11");
                return;
            }
            Object arg0 = arguments.get(0);
            Object arg1 = arguments.get(1);
            Object arg2 = arguments.get(2);
            if (!(arg0 instanceof COSInteger) && !(arg0 instanceof COSFloat) || !(arg1 instanceof COSInteger) && !(arg1 instanceof COSFloat)) {
                this.registerError("Invalid argument for the operator : " + operator.getOperation(), "1.2.11");
                return;
            }
            if (arg2 instanceof COSString) {
                this.validText(((COSString)arg2).getBytes());
                return;
            }
            this.registerError("Invalid argument for the operator : " + operator.getOperation(), "1.2.11");
            return;
        }
        Object objStr = arguments.get(0);
        if (objStr instanceof COSString) {
            this.validText(((COSString)objStr).getBytes());
            return;
        }
        if (objStr instanceof COSInteger) return;
        this.registerError("Invalid argument for the operator : " + operator.getOperation(), "1.2.11");
    }

    private void validStringArray(PDFOperator operator, List<?> arguments) throws ContentStreamException, IOException {
        for (Object object : arguments) {
            if (object instanceof COSArray) {
                this.validStringArray(operator, ((COSArray)object).toList());
                continue;
            }
            if (object instanceof COSString) {
                this.validText(((COSString)object).getBytes());
                continue;
            }
            if (object instanceof COSInteger || object instanceof COSFloat) continue;
            this.registerError("Invalid argument for the operator : " + operator.getOperation(), "1.2.11");
            return;
        }
    }

    public void validText(byte[] string) throws IOException {
        PDTextState textState = this.getGraphicsState().getTextState();
        int renderingMode = textState.getRenderingMode();
        PDFont font = textState.getFont();
        if (font == null) {
            this.registerError("Text operator can't be process without Font", "3.3.2");
            return;
        }
        FontContainer fontContainer = this.context.getFontContainer(font.getCOSObject());
        if (!(renderingMode != 3 || fontContainer != null && fontContainer.isEmbeddedFont())) {
            return;
        }
        if (fontContainer == null) {
            this.registerError(font.getBaseFont() + " is unknown wasn't found by the FontHelperValdiator", "3.3.2");
            return;
        }
        if (!fontContainer.isValid() && !fontContainer.errorsAleadyMerged()) {
            this.context.addValidationErrors(fontContainer.getAllErrors());
            fontContainer.setErrorsAleadyMerged(true);
            return;
        }
        if (!fontContainer.isValid() && fontContainer.errorsAleadyMerged()) {
            return;
        }
        fontContainer.setFont(font);
        int codeLength = 1;
        for (int i = 0; i < string.length; i += codeLength) {
            int cid = -1;
            codeLength = 1;
            try {
                cid = font.encodeToCID(string, i, codeLength);
                if (cid == -1 && i + 1 < string.length) {
                    cid = font.encodeToCID(string, i, ++codeLength);
                }
                fontContainer.checkGlyphWith(cid);
                continue;
            }
            catch (IOException e) {
                this.registerError("Encoding can't interpret the character code", "3.1.12");
                return;
            }
            catch (GlyphException e) {
                if (renderingMode == 3) continue;
                this.registerError(e.getMessage(), e.getErrorCode());
                return;
            }
        }
    }
}

