/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MethodAttributes is the corresponding interface of MethodAttributes
type MethodAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetUserExecutable returns UserExecutable (property field)
	GetUserExecutable() bool
	// GetExecutable returns Executable (property field)
	GetExecutable() bool
	// IsMethodAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMethodAttributes()
	// CreateBuilder creates a MethodAttributesBuilder
	CreateMethodAttributesBuilder() MethodAttributesBuilder
}

// _MethodAttributes is the data-structure of this message
type _MethodAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes uint32
	DisplayName         LocalizedText
	Description         LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	UserExecutable      bool
	Executable          bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ MethodAttributes = (*_MethodAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_MethodAttributes)(nil)

// NewMethodAttributes factory function for _MethodAttributes
func NewMethodAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, userExecutable bool, executable bool) *_MethodAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for MethodAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for MethodAttributes must not be nil")
	}
	_result := &_MethodAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		UserExecutable:                    userExecutable,
		Executable:                        executable,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MethodAttributesBuilder is a builder for MethodAttributes
type MethodAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, userExecutable bool, executable bool) MethodAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) MethodAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) MethodAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) MethodAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) MethodAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) MethodAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) MethodAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) MethodAttributesBuilder
	// WithUserExecutable adds UserExecutable (property field)
	WithUserExecutable(bool) MethodAttributesBuilder
	// WithExecutable adds Executable (property field)
	WithExecutable(bool) MethodAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the MethodAttributes or returns an error if something is wrong
	Build() (MethodAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MethodAttributes
}

// NewMethodAttributesBuilder() creates a MethodAttributesBuilder
func NewMethodAttributesBuilder() MethodAttributesBuilder {
	return &_MethodAttributesBuilder{_MethodAttributes: new(_MethodAttributes)}
}

type _MethodAttributesBuilder struct {
	*_MethodAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (MethodAttributesBuilder) = (*_MethodAttributesBuilder)(nil)

func (b *_MethodAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._MethodAttributes
}

func (b *_MethodAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, userExecutable bool, executable bool) MethodAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithUserExecutable(userExecutable).WithExecutable(executable)
}

func (b *_MethodAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) MethodAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_MethodAttributesBuilder) WithDisplayName(displayName LocalizedText) MethodAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_MethodAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) MethodAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_MethodAttributesBuilder) WithDescription(description LocalizedText) MethodAttributesBuilder {
	b.Description = description
	return b
}

func (b *_MethodAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) MethodAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_MethodAttributesBuilder) WithWriteMask(writeMask uint32) MethodAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_MethodAttributesBuilder) WithUserWriteMask(userWriteMask uint32) MethodAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_MethodAttributesBuilder) WithUserExecutable(userExecutable bool) MethodAttributesBuilder {
	b.UserExecutable = userExecutable
	return b
}

func (b *_MethodAttributesBuilder) WithExecutable(executable bool) MethodAttributesBuilder {
	b.Executable = executable
	return b
}

func (b *_MethodAttributesBuilder) Build() (MethodAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MethodAttributes.deepCopy(), nil
}

func (b *_MethodAttributesBuilder) MustBuild() MethodAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MethodAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_MethodAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_MethodAttributesBuilder) DeepCopy() any {
	_copy := b.CreateMethodAttributesBuilder().(*_MethodAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMethodAttributesBuilder creates a MethodAttributesBuilder
func (b *_MethodAttributes) CreateMethodAttributesBuilder() MethodAttributesBuilder {
	if b == nil {
		return NewMethodAttributesBuilder()
	}
	return &_MethodAttributesBuilder{_MethodAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_MethodAttributes) GetExtensionId() int32 {
	return int32(360)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MethodAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MethodAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_MethodAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_MethodAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_MethodAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_MethodAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_MethodAttributes) GetUserExecutable() bool {
	return m.UserExecutable
}

func (m *_MethodAttributes) GetExecutable() bool {
	return m.Executable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMethodAttributes(structType any) MethodAttributes {
	if casted, ok := structType.(MethodAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*MethodAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_MethodAttributes) GetTypeName() string {
	return "MethodAttributes"
}

func (m *_MethodAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 6

	// Simple field (userExecutable)
	lengthInBits += 1

	// Simple field (executable)
	lengthInBits += 1

	return lengthInBits
}

func (m *_MethodAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MethodAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__methodAttributes MethodAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MethodAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MethodAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(6)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	userExecutable, err := ReadSimpleField(ctx, "userExecutable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userExecutable' field"))
	}
	m.UserExecutable = userExecutable

	executable, err := ReadSimpleField(ctx, "executable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'executable' field"))
	}
	m.Executable = executable

	if closeErr := readBuffer.CloseContext("MethodAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MethodAttributes")
	}

	return m, nil
}

func (m *_MethodAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MethodAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MethodAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MethodAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 6)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "userExecutable", m.GetUserExecutable(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'userExecutable' field")
		}

		if err := WriteSimpleField[bool](ctx, "executable", m.GetExecutable(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'executable' field")
		}

		if popErr := writeBuffer.PopContext("MethodAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MethodAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MethodAttributes) IsMethodAttributes() {}

func (m *_MethodAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MethodAttributes) deepCopy() *_MethodAttributes {
	if m == nil {
		return nil
	}
	_MethodAttributesCopy := &_MethodAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		m.UserExecutable,
		m.Executable,
		m.reservedField0,
	}
	_MethodAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _MethodAttributesCopy
}

func (m *_MethodAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
