/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

public final class MessageSetFlowMode
extends Method {
    public static final int TYPE = 1033;
    private short packing_flags = 0;
    private String destination;
    private MessageFlowMode flowMode;

    @Override
    public final int getStructType() {
        return 1033;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageSetFlowMode() {
    }

    public MessageSetFlowMode(String destination, MessageFlowMode flowMode, Option ... _options) {
        if (destination != null) {
            this.setDestination(destination);
        }
        if (flowMode != null) {
            this.setFlowMode(flowMode);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageSetFlowMode(context, this);
    }

    public final boolean hasDestination() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageSetFlowMode clearDestination() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.destination = null;
        this.setDirty(true);
        return this;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final MessageSetFlowMode setDestination(String value) {
        this.destination = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final MessageSetFlowMode destination(String value) {
        return this.setDestination(value);
    }

    public final boolean hasFlowMode() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageSetFlowMode clearFlowMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.flowMode = null;
        this.setDirty(true);
        return this;
    }

    public final MessageFlowMode getFlowMode() {
        return this.flowMode;
    }

    public final MessageSetFlowMode setFlowMode(MessageFlowMode value) {
        this.flowMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final MessageSetFlowMode flowMode(MessageFlowMode value) {
        return this.setFlowMode(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.destination);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint8(this.flowMode.getValue());
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.destination = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.flowMode = MessageFlowMode.get(dec.readUint8());
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("destination", this.getDestination());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("flowMode", (Object)this.getFlowMode());
        }
        return result;
    }
}

