/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.batch;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.example.batch.ListSplitter;

public class SplitBatchProducer {
    public static final String PRODUCER_GROUP = "BatchProducerGroupName";
    public static final String DEFAULT_NAMESRVADDR = "127.0.0.1:9876";
    public static final int MESSAGE_COUNT = 100000;
    public static final String TOPIC = "BatchTest";
    public static final String TAG = "Tag";

    public static void main(String[] args) throws Exception {
        DefaultMQProducer producer = new DefaultMQProducer(PRODUCER_GROUP);
        producer.start();
        ArrayList<Message> messages = new ArrayList<Message>(100000);
        for (int i = 0; i < 100000; ++i) {
            messages.add(new Message(TOPIC, TAG, "OrderID" + i, ("Hello world " + i).getBytes()));
        }
        ListSplitter splitter = new ListSplitter(messages);
        while (splitter.hasNext()) {
            Object listItem = splitter.next();
            SendResult sendResult = producer.send((Collection)listItem);
            System.out.printf("%s", sendResult);
        }
    }
}

