/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.transaction.OperationResult;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.AsyncNettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.BrokerRole;

public class EndTransactionProcessor
extends AsyncNettyRequestProcessor {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqTransaction");
    private final BrokerController brokerController;

    public EndTransactionProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        EndTransactionRequestHeader requestHeader;
        RemotingCommand response;
        block19: {
            block18: {
                response = RemotingCommand.createResponseCommand(null);
                requestHeader = (EndTransactionRequestHeader)request.decodeCommandCustomHeader(EndTransactionRequestHeader.class);
                LOGGER.debug("Transaction request:{}", (Object)requestHeader);
                if (BrokerRole.SLAVE == this.brokerController.getMessageStoreConfig().getBrokerRole()) {
                    response.setCode(11);
                    LOGGER.warn("Message store is slave mode, so end transaction is forbidden. ");
                    return response;
                }
                if (!requestHeader.getFromTransactionCheck().booleanValue()) break block18;
                switch (requestHeader.getCommitOrRollback()) {
                    case 0: {
                        LOGGER.warn("Check producer[{}] transaction state, but it's pending status.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        return null;
                    }
                    case 8: {
                        LOGGER.warn("Check producer[{}] transaction state, the producer commit the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block19;
                    }
                    case 12: {
                        LOGGER.warn("Check producer[{}] transaction state, the producer rollback the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block19;
                    }
                    default: {
                        return null;
                    }
                }
            }
            switch (requestHeader.getCommitOrRollback()) {
                case 0: {
                    LOGGER.warn("The producer[{}] end transaction in sending message,  and it's pending status.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    return null;
                }
                case 8: {
                    break;
                }
                case 12: {
                    LOGGER.warn("The producer[{}] end transaction in sending message, rollback the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OperationResult result = new OperationResult();
        if (8 == requestHeader.getCommitOrRollback()) {
            result = this.brokerController.getTransactionalMessageService().commitMessage(requestHeader);
            if (result.getResponseCode() == 0) {
                RemotingCommand res = this.checkPrepareMessage(result.getPrepareMessage(), requestHeader);
                if (res.getCode() == 0) {
                    MessageExtBrokerInner msgInner = this.endMessageTransaction(result.getPrepareMessage());
                    msgInner.setSysFlag(MessageSysFlag.resetTransactionValue((int)msgInner.getSysFlag(), (int)requestHeader.getCommitOrRollback()));
                    msgInner.setQueueOffset(requestHeader.getTranStateTableOffset().longValue());
                    msgInner.setPreparedTransactionOffset(requestHeader.getCommitLogOffset().longValue());
                    msgInner.setStoreTimestamp(result.getPrepareMessage().getStoreTimestamp());
                    MessageAccessor.clearProperty((Message)msgInner, (String)"TRAN_MSG");
                    RemotingCommand sendResult = this.sendFinalMessage(msgInner);
                    if (sendResult.getCode() == 0) {
                        this.brokerController.getTransactionalMessageService().deletePrepareMessage(result.getPrepareMessage());
                    }
                    return sendResult;
                }
                return res;
            }
        } else if (12 == requestHeader.getCommitOrRollback() && (result = this.brokerController.getTransactionalMessageService().rollbackMessage(requestHeader)).getResponseCode() == 0) {
            RemotingCommand res = this.checkPrepareMessage(result.getPrepareMessage(), requestHeader);
            if (res.getCode() == 0) {
                this.brokerController.getTransactionalMessageService().deletePrepareMessage(result.getPrepareMessage());
            }
            return res;
        }
        response.setCode(result.getResponseCode());
        response.setRemark(result.getResponseRemark());
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand checkPrepareMessage(MessageExt msgExt, EndTransactionRequestHeader requestHeader) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (msgExt != null) {
            String pgroupRead = msgExt.getProperty("PGROUP");
            if (!pgroupRead.equals(requestHeader.getProducerGroup())) {
                response.setCode(1);
                response.setRemark("The producer group wrong");
                return response;
            }
            if (msgExt.getQueueOffset() != requestHeader.getTranStateTableOffset().longValue()) {
                response.setCode(1);
                response.setRemark("The transaction state table offset wrong");
                return response;
            }
            if (msgExt.getCommitLogOffset() != requestHeader.getCommitLogOffset().longValue()) {
                response.setCode(1);
                response.setRemark("The commit log offset wrong");
                return response;
            }
        } else {
            response.setCode(1);
            response.setRemark("Find prepared transaction message failed");
            return response;
        }
        response.setCode(0);
        return response;
    }

    private MessageExtBrokerInner endMessageTransaction(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(msgExt.getUserProperty("REAL_TOPIC"));
        msgInner.setQueueId(Integer.parseInt(msgExt.getUserProperty("REAL_QID")));
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        msgInner.setTransactionId(msgExt.getUserProperty("UNIQ_KEY"));
        msgInner.setSysFlag(msgExt.getSysFlag());
        TopicFilterType topicFilterType = (msgInner.getSysFlag() & 2) == 2 ? TopicFilterType.MULTI_TAG : TopicFilterType.SINGLE_TAG;
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_TOPIC");
        MessageAccessor.clearProperty((Message)msgInner, (String)"REAL_QID");
        return msgInner;
    }

    private RemotingCommand sendFinalMessage(MessageExtBrokerInner msgInner) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
        if (putMessageResult != null) {
            switch (putMessageResult.getPutMessageStatus()) {
                case PUT_OK: 
                case FLUSH_DISK_TIMEOUT: 
                case FLUSH_SLAVE_TIMEOUT: 
                case SLAVE_NOT_AVAILABLE: {
                    response.setCode(0);
                    response.setRemark(null);
                    break;
                }
                case CREATE_MAPEDFILE_FAILED: {
                    response.setCode(1);
                    response.setRemark("Create mapped file failed.");
                    break;
                }
                case MESSAGE_ILLEGAL: 
                case PROPERTIES_SIZE_EXCEEDED: {
                    response.setCode(13);
                    response.setRemark(String.format("The message is illegal, maybe msg body or properties length not matched. msg body length limit %dB, msg properties length limit 32KB.", this.brokerController.getMessageStoreConfig().getMaxMessageSize()));
                    break;
                }
                case SERVICE_NOT_AVAILABLE: {
                    response.setCode(14);
                    response.setRemark("Service not available now.");
                    break;
                }
                case OS_PAGECACHE_BUSY: {
                    response.setCode(1);
                    response.setRemark("OS page cache busy, please try another machine");
                    break;
                }
                case UNKNOWN_ERROR: {
                    response.setCode(1);
                    response.setRemark("UNKNOWN_ERROR");
                    break;
                }
                default: {
                    response.setCode(1);
                    response.setRemark("UNKNOWN_ERROR DEFAULT");
                }
            }
            return response;
        }
        response.setCode(1);
        response.setRemark("store putMessage return null");
        return response;
    }
}

