/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import io.netty.channel.Channel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public abstract class AbstractTransactionalMessageCheckListener {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqTransaction");
    private BrokerController brokerController;
    protected static final int TCMT_QUEUE_NUMS = 1;
    private static ExecutorService executorService = new ThreadPoolExecutor(2, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Transaction-msg-check-thread");
            return thread;
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());

    public AbstractTransactionalMessageCheckListener() {
    }

    public AbstractTransactionalMessageCheckListener(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void sendCheckMessage(MessageExt msgExt) throws Exception {
        CheckTransactionStateRequestHeader checkTransactionStateRequestHeader = new CheckTransactionStateRequestHeader();
        checkTransactionStateRequestHeader.setCommitLogOffset(Long.valueOf(msgExt.getCommitLogOffset()));
        checkTransactionStateRequestHeader.setOffsetMsgId(msgExt.getMsgId());
        checkTransactionStateRequestHeader.setMsgId(msgExt.getUserProperty("UNIQ_KEY"));
        checkTransactionStateRequestHeader.setTransactionId(checkTransactionStateRequestHeader.getMsgId());
        checkTransactionStateRequestHeader.setTranStateTableOffset(Long.valueOf(msgExt.getQueueOffset()));
        msgExt.setTopic(msgExt.getUserProperty("REAL_TOPIC"));
        msgExt.setQueueId(Integer.parseInt(msgExt.getUserProperty("REAL_QID")));
        msgExt.setStoreSize(0);
        String groupId = msgExt.getProperty("PGROUP");
        Channel channel = this.brokerController.getProducerManager().getAvailableChannel(groupId);
        if (channel != null) {
            this.brokerController.getBroker2Client().checkProducerTransactionState(groupId, channel, checkTransactionStateRequestHeader, msgExt);
        } else {
            LOGGER.warn("Check transaction failed, channel is null. groupId={}", (Object)groupId);
        }
    }

    public void resolveHalfMsg(final MessageExt msgExt) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractTransactionalMessageCheckListener.this.sendCheckMessage(msgExt);
                }
                catch (Exception e) {
                    LOGGER.error("Send check message error!", (Throwable)e);
                }
            }
        });
    }

    public BrokerController getBrokerController() {
        return this.brokerController;
    }

    public void shutDown() {
        executorService.shutdown();
    }

    public void setBrokerController(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public abstract void resolveDiscardMsg(MessageExt var1);
}

