/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.channel;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.StartAndShutdown;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcClientChannel;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayResult;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;

public class GrpcChannelManager
implements StartAndShutdown {
    private final ProxyRelayService proxyRelayService;
    private final GrpcClientSettingsManager grpcClientSettingsManager;
    protected final ConcurrentMap<String, GrpcClientChannel> clientIdChannelMap = new ConcurrentHashMap<String, GrpcClientChannel>();
    protected final AtomicLong nonceIdGenerator = new AtomicLong(0L);
    protected final ConcurrentMap<String, ResultFuture> resultNonceFutureMap = new ConcurrentHashMap<String, ResultFuture>();
    protected final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("GrpcChannelManager_"));

    public GrpcChannelManager(ProxyRelayService proxyRelayService, GrpcClientSettingsManager grpcClientSettingsManager) {
        this.proxyRelayService = proxyRelayService;
        this.grpcClientSettingsManager = grpcClientSettingsManager;
    }

    protected void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::scanExpireResultFuture, 10L, 10L, TimeUnit.SECONDS);
    }

    public GrpcClientChannel createChannel(ProxyContext ctx, String clientId) {
        return this.clientIdChannelMap.computeIfAbsent(clientId, k -> new GrpcClientChannel(this.proxyRelayService, this.grpcClientSettingsManager, this, ctx, clientId));
    }

    public GrpcClientChannel getChannel(String clientId) {
        return (GrpcClientChannel)this.clientIdChannelMap.get(clientId);
    }

    public GrpcClientChannel removeChannel(String clientId) {
        return (GrpcClientChannel)this.clientIdChannelMap.remove(clientId);
    }

    public <T> String addResponseFuture(CompletableFuture<ProxyRelayResult<T>> responseFuture) {
        String nonce = this.nextNonce();
        this.resultNonceFutureMap.put(nonce, new ResultFuture<T>(responseFuture));
        return nonce;
    }

    public <T> CompletableFuture<ProxyRelayResult<T>> getAndRemoveResponseFuture(String nonce) {
        ResultFuture resultFuture = (ResultFuture)this.resultNonceFutureMap.remove(nonce);
        if (resultFuture != null) {
            return resultFuture.future;
        }
        return null;
    }

    protected String nextNonce() {
        return String.valueOf(this.nonceIdGenerator.getAndIncrement());
    }

    protected void scanExpireResultFuture() {
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        long timeOutMs = TimeUnit.SECONDS.toMillis(proxyConfig.getGrpcProxyRelayRequestTimeoutInSeconds());
        Set nonceSet = this.resultNonceFutureMap.keySet();
        for (String nonce : nonceSet) {
            ResultFuture resultFuture = (ResultFuture)this.resultNonceFutureMap.get(nonce);
            if (resultFuture == null || System.currentTimeMillis() - resultFuture.createTime <= timeOutMs || (resultFuture = (ResultFuture)this.resultNonceFutureMap.remove(nonce)) == null) continue;
            resultFuture.future.complete(new ProxyRelayResult<Object>(2, "call remote timeout", null));
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void start() throws Exception {
    }

    protected static class ResultFuture<T> {
        public CompletableFuture<ProxyRelayResult<T>> future;
        public long createTime = System.currentTimeMillis();

        public ResultFuture(CompletableFuture<ProxyRelayResult<T>> future) {
            this.future = future;
        }
    }
}

