/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.MixAll;

public class BroadcastOffsetStore {
    private final ConcurrentMap<Integer, AtomicLong> offsetTable = new ConcurrentHashMap<Integer, AtomicLong>();

    public void updateOffset(int queueId, long offset, boolean increaseOnly) {
        AtomicLong offsetOld = (AtomicLong)this.offsetTable.get(queueId);
        if (null == offsetOld) {
            offsetOld = this.offsetTable.putIfAbsent(queueId, new AtomicLong(offset));
        }
        if (null != offsetOld) {
            if (increaseOnly) {
                MixAll.compareAndIncreaseOnly((AtomicLong)offsetOld, (long)offset);
            } else {
                offsetOld.set(offset);
            }
        }
    }

    public long readOffset(int queueId) {
        AtomicLong offset = (AtomicLong)this.offsetTable.get(queueId);
        if (offset != null) {
            return offset.get();
        }
        return -1L;
    }

    public Set<Integer> queueList() {
        return this.offsetTable.keySet();
    }
}

