/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer.rebalance;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.client.consumer.rebalance.AbstractAllocateMessageQueueStrategy;
import org.apache.rocketmq.common.consistenthash.ConsistentHashRouter;
import org.apache.rocketmq.common.consistenthash.HashFunction;
import org.apache.rocketmq.common.consistenthash.Node;
import org.apache.rocketmq.common.message.MessageQueue;

public class AllocateMessageQueueConsistentHash
extends AbstractAllocateMessageQueueStrategy {
    private final int virtualNodeCnt;
    private final HashFunction customHashFunction;

    public AllocateMessageQueueConsistentHash() {
        this(10);
    }

    public AllocateMessageQueueConsistentHash(int virtualNodeCnt) {
        this(virtualNodeCnt, null);
    }

    public AllocateMessageQueueConsistentHash(int virtualNodeCnt, HashFunction customHashFunction) {
        if (virtualNodeCnt < 0) {
            throw new IllegalArgumentException("illegal virtualNodeCnt :" + virtualNodeCnt);
        }
        this.virtualNodeCnt = virtualNodeCnt;
        this.customHashFunction = customHashFunction;
    }

    @Override
    public List<MessageQueue> allocate(String consumerGroup, String currentCID, List<MessageQueue> mqAll, List<String> cidAll) {
        ArrayList<MessageQueue> result = new ArrayList<MessageQueue>();
        if (!this.check(consumerGroup, currentCID, mqAll, cidAll)) {
            return result;
        }
        ArrayList<ClientNode> cidNodes = new ArrayList<ClientNode>();
        for (String cid : cidAll) {
            cidNodes.add(new ClientNode(cid));
        }
        ConsistentHashRouter router = this.customHashFunction != null ? new ConsistentHashRouter(cidNodes, this.virtualNodeCnt, this.customHashFunction) : new ConsistentHashRouter(cidNodes, this.virtualNodeCnt);
        ArrayList<MessageQueue> results = new ArrayList<MessageQueue>();
        for (MessageQueue mq : mqAll) {
            ClientNode clientNode = (ClientNode)router.routeNode(mq.toString());
            if (clientNode == null || !currentCID.equals(clientNode.getKey())) continue;
            results.add(mq);
        }
        return results;
    }

    @Override
    public String getName() {
        return "CONSISTENT_HASH";
    }

    private static class ClientNode
    implements Node {
        private final String clientID;

        public ClientNode(String clientID) {
            this.clientID = clientID;
        }

        public String getKey() {
            return this.clientID;
        }
    }
}

