/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.message;

import java.nio.ByteBuffer;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageVersion;
import org.apache.rocketmq.common.utils.MessageUtils;

public class MessageExtBrokerInner
extends MessageExt {
    private static final long serialVersionUID = 7256001576878700634L;
    private String propertiesString;
    private long tagsCode;
    private ByteBuffer encodedBuff;
    private volatile boolean encodeCompleted;
    private MessageVersion version = MessageVersion.MESSAGE_VERSION_V1;

    public ByteBuffer getEncodedBuff() {
        return this.encodedBuff;
    }

    public void setEncodedBuff(ByteBuffer encodedBuff) {
        this.encodedBuff = encodedBuff;
    }

    public static long tagsString2tagsCode(TopicFilterType filter, String tags) {
        if (null == tags || tags.length() == 0) {
            return 0L;
        }
        return tags.hashCode();
    }

    public static long tagsString2tagsCode(String tags) {
        return MessageExtBrokerInner.tagsString2tagsCode(null, tags);
    }

    public String getPropertiesString() {
        return this.propertiesString;
    }

    public void setPropertiesString(String propertiesString) {
        this.propertiesString = propertiesString;
    }

    public void deleteProperty(String name) {
        super.clearProperty(name);
        if (this.propertiesString != null) {
            this.setPropertiesString(MessageUtils.deleteProperty(this.propertiesString, name));
        }
    }

    public long getTagsCode() {
        return this.tagsCode;
    }

    public void setTagsCode(long tagsCode) {
        this.tagsCode = tagsCode;
    }

    public MessageVersion getVersion() {
        return this.version;
    }

    public void setVersion(MessageVersion version) {
        this.version = version;
    }

    public void removeWaitStorePropertyString() {
        if (this.getProperties().containsKey("WAIT")) {
            String waitStoreMsgOKValue = this.getProperties().remove("WAIT");
            this.setPropertiesString(MessageDecoder.messageProperties2String(this.getProperties()));
            this.getProperties().put("WAIT", waitStoreMsgOKValue);
        } else {
            this.setPropertiesString(MessageDecoder.messageProperties2String(this.getProperties()));
        }
    }

    public boolean isEncodeCompleted() {
        return this.encodeCompleted;
    }

    public void setEncodeCompleted(boolean encodeCompleted) {
        this.encodeCompleted = encodeCompleted;
    }
}

