/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rpc.RpcContext;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessClosure<REQ, RSP>
implements Closure {
    private static final Logger LOG = LoggerFactory.getLogger(RequestProcessClosure.class);
    private static final AtomicIntegerFieldUpdater<RequestProcessClosure> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RequestProcessClosure.class, "state");
    private static final int PENDING = 0;
    private static final int RESPOND = 1;
    private final REQ request;
    private final RpcContext rpcCtx;
    private RSP response;
    private volatile int state = 0;

    public RequestProcessClosure(REQ request, RpcContext rpcCtx) {
        this.request = request;
        this.rpcCtx = rpcCtx;
    }

    public RpcContext getRpcCtx() {
        return this.rpcCtx;
    }

    public REQ getRequest() {
        return this.request;
    }

    public RSP getResponse() {
        return this.response;
    }

    public void sendResponse(RSP response) {
        this.response = response;
        this.run(null);
    }

    public void run(Status status) {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            LOG.warn("A response: {} with status: {} sent repeatedly!", this.response, (Object)status);
            return;
        }
        this.rpcCtx.sendResponse(this.response);
    }
}

