/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.metadata;

import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.StoreLabel;
import com.alipay.sofa.jraft.rhea.metadata.StoreState;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.util.Copiable;
import com.alipay.sofa.jraft.util.Endpoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Store
implements Copiable<Store>,
Serializable {
    private static final long serialVersionUID = 8566110829366373797L;
    private long id;
    private Endpoint endpoint;
    private StoreState state;
    private List<Region> regions;
    private List<StoreLabel> labels;

    public Store() {
    }

    public Store(long id, Endpoint endpoint, StoreState state, List<Region> regions, List<StoreLabel> labels) {
        this.id = id;
        this.endpoint = endpoint;
        this.state = state;
        this.regions = regions;
        this.labels = labels;
    }

    public boolean isEmpty() {
        return this.endpoint == null || this.regions == null || this.regions.isEmpty();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public void setRegions(List<Region> regions) {
        this.regions = regions;
    }

    public Store copy() {
        Endpoint endpoint = null;
        if (this.endpoint != null) {
            endpoint = this.endpoint.copy();
        }
        ArrayList<Region> regions = null;
        if (this.regions != null) {
            regions = Lists.newArrayListWithCapacity(this.regions.size());
            for (Region region : this.regions) {
                regions.add(region.copy());
            }
        }
        ArrayList<StoreLabel> labels = null;
        if (this.labels != null) {
            labels = Lists.newArrayListWithCapacity(this.labels.size());
            for (StoreLabel label : this.labels) {
                labels.add(label.copy());
            }
        }
        return new Store(this.id, endpoint, this.state, regions, labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Store store = (Store)o;
        return this.id == store.id && Objects.equals(this.endpoint, store.endpoint);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.endpoint);
    }

    public String toString() {
        return "Store{id=" + this.id + ", endpoint=" + this.endpoint + ", state=" + (Object)((Object)this.state) + ", regions=" + this.regions + ", labels=" + this.labels + '}';
    }
}

