/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.hook;

import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.mqtt.common.hook.Hook;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHook;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookEnum;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookManager;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.springframework.stereotype.Component;

@Component
public class UpstreamHookManagerImpl
implements UpstreamHookManager {
    private UpstreamHook[] upstreamHookList = new UpstreamHook[UpstreamHookEnum.values().length];
    private AtomicBoolean isAssembled = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHook(int index, UpstreamHook upstreamHook) {
        if (this.isAssembled.get()) {
            throw new IllegalArgumentException("Hook Was Assembled");
        }
        UpstreamHook[] upstreamHookArray = this.upstreamHookList;
        synchronized (this.upstreamHookList) {
            this.upstreamHookList[index] = upstreamHook;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public CompletableFuture<HookResult> doUpstreamHook(MqttMessageUpContext context, MqttMessage msg) {
        this.assembleNextHook();
        CompletableFuture<HookResult> hookResult = new CompletableFuture<HookResult>();
        if (this.upstreamHookList.length <= 0) {
            hookResult.complete(new HookResult(200, -1, null, null));
            return hookResult;
        }
        return this.upstreamHookList[0].doHook(context, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assembleNextHook() {
        if (!this.isAssembled.compareAndSet(false, true)) return;
        UpstreamHook[] upstreamHookArray = this.upstreamHookList;
        synchronized (this.upstreamHookList) {
            for (int i = 0; i < this.upstreamHookList.length - 1; ++i) {
                UpstreamHook upstreamHook = this.upstreamHookList[i];
                if (upstreamHook.getNextHook() != null) continue;
                upstreamHook.setNextHook((Hook)this.upstreamHookList[i + 1]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

