/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer;

import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.servicecomb.swagger.generator.rest.RestSwaggerGeneratorContext;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.FieldInfo;
import org.apache.servicecomb.swagger.invocation.arguments.ProviderParameter;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentSame;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.arguments.producer.SwaggerArgumentToProducerBodyField;
import org.apache.servicecomb.swagger.invocation.converter.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class ProducerArgumentsMapperFactory
extends ArgumentsMapperFactory<ProducerArgumentsMapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerArgumentsMapperFactory.class);

    public ProducerArgumentsMapperFactory() {
        this.type = InvocationType.PRODUCER;
    }

    @Inject
    @Qualifier(value="producer")
    public void setFactoryList(List<ContextArgumentMapperFactory> factoryList) {
        this.createFactoryMap(factoryList);
    }

    @Override
    public ProducerArgumentsMapper createArgumentsMapper(ArgumentsMapperConfig config) {
        this.collectArgumentsMapper(config);
        return new ProducerArgumentsMapper(config.getArgumentMapperList(), config.getProviderMethod().getParameterCount());
    }

    public boolean canProcess(ArgumentsMapperConfig config) {
        return false;
    }

    @Override
    protected void collectSwaggerArgumentsMapper(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Map<String, ParamWrapper<Parameter>> swaggerParamMap;
        if (!RestSwaggerGeneratorContext.class.isInstance(config.getSwaggerGeneratorContext())) {
            super.collectSwaggerArgumentsMapper(config, providerNormalParams);
            return;
        }
        Map<String, ProviderParameter> providerParamMap = this.getProviderParamMap(providerNormalParams);
        Set<String> aggregatedParamNames = this.findAggregatedParamNames(providerParamMap, swaggerParamMap = this.getSwaggerParamMap(config));
        if (aggregatedParamNames.isEmpty()) {
            super.collectSwaggerArgumentsMapper(config, providerNormalParams);
            return;
        }
        this.generateParamMapperByName(config, providerParamMap, swaggerParamMap, aggregatedParamNames);
    }

    private void generateParamMapperByName(ArgumentsMapperConfig config, Map<String, ProviderParameter> providerParamMap, Map<String, ParamWrapper<Parameter>> swaggerParamMap, Set<String> aggregatedParamNames) {
        LOGGER.info("mapping aggregated params: [{}]", aggregatedParamNames);
        this.generateAggregatedParamMapper(config, providerParamMap, swaggerParamMap, aggregatedParamNames);
        this.generateDefaultParamMapper(config, providerParamMap, swaggerParamMap, aggregatedParamNames);
    }

    private void generateDefaultParamMapper(ArgumentsMapperConfig config, Map<String, ProviderParameter> providerParamMap, Map<String, ParamWrapper<Parameter>> swaggerParamMap, Set<String> aggregatedParamNames) {
        Type[] swaggerParamTypes = config.getSwaggerMethod().getGenericParameterTypes();
        for (Map.Entry<String, ProviderParameter> providerParamEntry : providerParamMap.entrySet()) {
            if (aggregatedParamNames.contains(providerParamEntry.getKey())) continue;
            int swaggerIdx = swaggerParamMap.get(providerParamEntry.getKey()).getIndex();
            Converter converter = this.converterMgr.findConverter(this.type, providerParamEntry.getValue().getType(), swaggerParamTypes[swaggerIdx]);
            ArgumentMapper mapper = this.createArgumentMapperWithConverter(swaggerIdx, providerParamEntry.getValue().getIndex(), converter);
            config.addArgumentMapper(mapper);
        }
    }

    protected void generateAggregatedParamMapper(ArgumentsMapperConfig config, Map<String, ProviderParameter> providerParamMap, Map<String, ParamWrapper<Parameter>> swaggerParamMap, Set<String> aggregatedParamNames) {
    }

    protected Map<String, ParamWrapper<Parameter>> getSwaggerParamMap(ArgumentsMapperConfig config) {
        HashMap<String, ParamWrapper<Parameter>> swaggerParamMap = new HashMap<String, ParamWrapper<Parameter>>();
        if (null == config.getSwaggerOperation() || null == config.getSwaggerOperation().getParameters()) {
            return swaggerParamMap;
        }
        List parameters = config.getSwaggerOperation().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            swaggerParamMap.put(parameter.getName(), new ParamWrapper<Parameter>(parameter).setIndex(i));
        }
        return swaggerParamMap;
    }

    protected Map<String, ProviderParameter> getProviderParamMap(List<ProviderParameter> providerNormalParams) {
        HashMap<String, ProviderParameter> providerParamMap = new HashMap<String, ProviderParameter>(providerNormalParams.size());
        providerNormalParams.forEach(providerParameter -> providerParamMap.put(providerParameter.getName(), (ProviderParameter)providerParameter));
        return providerParamMap;
    }

    protected Set<String> findAggregatedParamNames(Map<String, ProviderParameter> providerParamMap, Map<String, ParamWrapper<Parameter>> swaggerParamMap) {
        return Collections.emptySet();
    }

    @Override
    protected ArgumentMapper createArgumentMapperWithConverter(int swaggerIdx, int producerIdx, Converter converter) {
        return new ProducerArgumentSame(swaggerIdx, producerIdx, converter);
    }

    @Override
    protected ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig config, Map<Integer, FieldInfo> fieldMap) {
        return new SwaggerArgumentToProducerBodyField(fieldMap);
    }

    public static class ParamWrapper<T> {
        T param;
        int index;

        public ParamWrapper(T param) {
            this.param = param;
        }

        public T getParam() {
            return this.param;
        }

        public ParamWrapper<T> setParam(T param) {
            this.param = param;
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public ParamWrapper<T> setIndex(int index) {
            this.index = index;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ParamWrapper{");
            sb.append("param=").append(this.param);
            sb.append(", index=").append(this.index);
            sb.append('}');
            return sb.toString();
        }
    }
}

