/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.net;

import com.netflix.spectator.api.Id;

public class NetStat {
    private final int index;
    private Id id;
    private long lastValue;
    private double rate;

    public NetStat(Id id, int index) {
        this.id = id;
        this.index = index;
    }

    public void clearRate() {
        this.rate = 0.0;
    }

    public void update(String[] netInfo, long secondInterval) {
        long currentValue = Long.parseLong(netInfo[this.index]);
        this.rate = (double)(currentValue - this.lastValue) / (double)secondInterval;
        this.lastValue = currentValue;
    }

    public long getLastValue() {
        return this.lastValue;
    }

    public double getRate() {
        return this.rate;
    }

    public int getIndex() {
        return this.index;
    }

    public Id getId() {
        return this.id;
    }
}

