/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.HashMap;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.serviceregistry.client.http.RequestParam;
import org.apache.servicecomb.serviceregistry.client.http.RestUtils;
import org.apache.servicecomb.serviceregistry.client.http.WebsocketClientPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebsocketUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketUtils.class);

    private WebsocketUtils() {
    }

    public static void open(IpPort ipPort, String url, Handler<Void> onOpen, Handler<Void> onClose, Handler<Buffer> onMessage, Handler<Throwable> onException, Handler<Throwable> onConnectFailed) {
        HttpClientWithContext vertxHttpClient = WebsocketClientPool.INSTANCE.getClient();
        vertxHttpClient.runOnContext(client -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions();
            options.setHost(ipPort.getHostOrIp()).setPort(ipPort.getPort()).setURI(url).setHeaders(RestUtils.getDefaultHeaders().addAll(RestUtils.getSignAuthHeaders(RestUtils.createSignRequest(HttpMethod.GET.name(), ipPort, new RequestParam(), url, new HashMap<String, String>()))));
            client.webSocket(options, asyncResult -> {
                if (asyncResult.failed()) {
                    onConnectFailed.handle((Object)asyncResult.cause());
                } else {
                    onOpen.handle(null);
                    ((WebSocket)asyncResult.result()).exceptionHandler(v -> {
                        onException.handle(v);
                        try {
                            ((WebSocket)asyncResult.result()).close();
                        }
                        catch (Exception err) {
                            LOGGER.error("ws close error.", (Throwable)err);
                        }
                    });
                    ((WebSocket)asyncResult.result()).closeHandler(v -> onClose.handle(v));
                    ((WebSocket)asyncResult.result()).pongHandler(pong -> {});
                    ((WebSocket)asyncResult.result()).frameHandler(frame -> {
                        if (frame.isBinary() || frame.isText()) {
                            onMessage.handle((Object)frame.binaryData());
                        }
                    });
                }
            });
        });
    }
}

