/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.internal.shared.ColorModelBuilder;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.gdal.Band;
import org.apache.sis.storage.gdal.DataType;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.SpatialRef;
import org.apache.sis.storage.gdal.TiledCoverage;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.GenericName;

final class TiledResource
extends TiledGridResource {
    private static final int LARGE_TILE_SIZE = 0x1000000;
    final GDALStore parent;
    private final int imageIndex;
    private final GenericName identifier;
    private GridGeometry geometry;
    private final int width;
    private final int height;
    private final int tileWidth;
    private final int tileHeight;
    final DataType dataType;
    private final Band[] bands;
    private List<SampleDimension> sampleDimensions;
    private int[] selectedBandIndices;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private Number[] fillValues;

    private TiledResource(GDALStore parent, int imageIndex, SizeAndType size, List<Band> bands) throws DataStoreException {
        super((Resource)parent);
        Dimension t = size.tileSize();
        this.tileWidth = t.width;
        this.tileHeight = t.height;
        this.parent = parent;
        this.imageIndex = imageIndex;
        this.identifier = parent.factory.createLocalName(parent.namespace, (CharSequence)String.valueOf(imageIndex)).toFullyQualifiedName();
        this.width = size.width();
        this.height = size.height();
        this.dataType = DataType.valueOf(size.type());
        this.bands = (Band[])bands.toArray(Band[]::new);
    }

    static TiledResource[] groupBySizeAndType(GDALStore parent, GDAL gdal) throws DataStoreException {
        int mainHeight;
        int mainWidth;
        MemorySegment dataset = parent.handle();
        LinkedHashMap<SizeAndType, ArrayList> bands = new LinkedHashMap<SizeAndType, ArrayList>();
        try (Arena arena = Arena.ofConfined();){
            ValueLayout.OfInt layout = ValueLayout.JAVA_INT;
            MemorySegment pnXSize = arena.allocate(layout, 2L);
            MemorySegment memorySegment = pnXSize.asSlice(layout.byteSize());
            int count = gdal.getRasterCount.invokeExact(dataset);
            for (int i = 0; i < count; ++i) {
                MemorySegment band = gdal.getRasterBand.invokeExact(dataset, i + 1);
                if (GDAL.isNull(band)) continue;
                int width = gdal.getRasterBandXSize.invokeExact(band);
                int height = gdal.getRasterBandYSize.invokeExact(band);
                int type = gdal.getRasterDataType.invokeExact(band);
                gdal.getBlockSize.invokeExact(band, pnXSize, memorySegment);
                int tileWidth = pnXSize.get(layout, 0L);
                int tileHeight = memorySegment.get(layout, 0L);
                SizeAndType key = new SizeAndType(width, height, type, tileWidth, tileHeight);
                bands.computeIfAbsent(key, sizeAndType -> new ArrayList()).add(new Band(band));
            }
            mainWidth = gdal.getRasterXSize.invokeExact(dataset);
            mainHeight = gdal.getRasterYSize.invokeExact(dataset);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        TiledResource[] rasters = new TiledResource[bands.size()];
        int count = 0;
        for (Map.Entry entry : bands.entrySet()) {
            rasters[count++] = new TiledResource(parent, count, (SizeAndType)entry.getKey(), (List)entry.getValue());
        }
        for (int i = 0; i < count; ++i) {
            TiledResource tiledResource = rasters[i];
            if (tiledResource.width != mainWidth || tiledResource.height != mainHeight) continue;
            System.arraycopy(rasters, 0, rasters, 1, i);
            rasters[0] = tiledResource;
            break;
        }
        return (TiledResource[])ArraysExt.resize((Object[])rasters, (int)count);
    }

    protected final Object getSynchronizationLock() {
        return this.parent;
    }

    public final Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        this.parent.addFormatInfo(builder);
        builder.addTitle((CharSequence)Vocabulary.formatInternational((short)261, (Object)this.imageIndex));
        builder.addDefaultMetadata((AbstractGridCoverageResource)this, this.listeners);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGeometry getGridGeometry() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.geometry == null) {
                try {
                    int dimension;
                    Matrix swap;
                    MemorySegment handle = this.parent.handle();
                    GDAL gdal = this.parent.getProvider().GDAL();
                    SpatialRef srs = SpatialRef.create(this.parent, gdal, handle);
                    CoordinateReferenceSystem crs = srs != null ? srs.parseCRS("getGridGeometry") : null;
                    MathTransform gridToCRS = null;
                    try (Arena arena = Arena.ofConfined();){
                        int err;
                        ValueLayout.OfDouble layout = ValueLayout.JAVA_DOUBLE;
                        MemorySegment m = arena.allocate(layout, 6L);
                        try {
                            err = gdal.getGeoTransform.invokeExact(handle, m);
                        }
                        catch (Throwable e) {
                            throw GDAL.propagate(e);
                        }
                        if (ErrorHandler.checkCPLErr(err)) {
                            gridToCRS = new AffineTransform2D(m.getAtIndex(layout, 1L), m.getAtIndex(layout, 4L), m.getAtIndex(layout, 2L), m.getAtIndex(layout, 5L), m.getAtIndex(layout, 0L), m.getAtIndex(layout, 3L));
                        }
                    }
                    if (gridToCRS != null && srs != null && (swap = srs.getDataToCRS(dimension = crs != null ? crs.getCoordinateSystem().getDimension() : 2)) != null) {
                        gridToCRS = MathTransforms.concatenate(gridToCRS, (MathTransform)MathTransforms.linear((Matrix)swap));
                    }
                    GridExtent extent = new GridExtent(Integer.toUnsignedLong(this.width), Integer.toUnsignedLong(this.height));
                    try {
                        this.geometry = new GridGeometry(extent, PixelInCell.CELL_CORNER, gridToCRS, crs);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new DataStoreReferencingException((Throwable)e);
                    }
                }
                finally {
                    ErrorHandler.report(this.parent, "getGridGeometry");
                }
            }
            return this.geometry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.sampleDimensions == null) {
                try {
                    GDAL gdal = this.parent.getProvider().GDAL();
                    SampleDimension[] sd = new SampleDimension[this.bands.length];
                    try (Arena arena = Arena.ofConfined();){
                        MemorySegment flag = arena.allocate(ValueLayout.JAVA_INT);
                        for (int i = 0; i < sd.length; ++i) {
                            sd[i] = this.bands[i].createSampleDimension(this.parent, gdal, flag);
                        }
                    }
                    this.sampleDimensions = List.of(sd);
                }
                finally {
                    ErrorHandler.report(this.parent, "getSampleDimensions");
                }
            }
            return this.sampleDimensions;
        }
    }

    protected final boolean canSeparateBands() {
        return true;
    }

    protected final int getAtomSize(int dim) {
        return 1;
    }

    final Band[] bands(int[] bandIndices) {
        if (bandIndices == null) {
            return this.bands;
        }
        Band[] selectedBands = new Band[bandIndices.length];
        for (int i = 0; i < bandIndices.length; ++i) {
            selectedBands[i] = this.bands[bandIndices[i]];
        }
        return selectedBands;
    }

    private void createColorAndSampleModel(int[] bandIndices) throws DataStoreException {
        Band[] selectedBands = this.bands(bandIndices);
        GDAL gdal = this.parent.getProvider().GDAL();
        int[] palette = null;
        int paletteIndex = 0;
        int alpha = -1;
        int red = -1;
        int green = -1;
        int blue = -1;
        int gray = -1;
        block8: for (int i = 0; i < selectedBands.length; ++i) {
            Band band = selectedBands[i];
            switch (band.getColorInterpretation(gdal)) {
                case ALPHA: {
                    if (alpha >= 0) continue block8;
                    alpha = i;
                    continue block8;
                }
                case RED: {
                    if (red >= 0) continue block8;
                    red = i;
                    continue block8;
                }
                case GREEN: {
                    if (green >= 0) continue block8;
                    green = i;
                    continue block8;
                }
                case BLUE: {
                    if (blue >= 0) continue block8;
                    blue = i;
                    continue block8;
                }
                case GRAYSCALE: {
                    if (gray >= 0) continue block8;
                    gray = i;
                    continue block8;
                }
                case PALETTE: {
                    if (palette != null) continue block8;
                    paletteIndex = i;
                    palette = band.getARGB(gdal);
                }
            }
        }
        if ((red | green | blue) >= 0) {
            this.colorModel = new ColorModelBuilder().bitsPerSample((int)this.dataType.numBits).alphaBand(alpha).createBandedRGB();
        } else if (palette != null) {
            this.colorModel = ColorModelFactory.createIndexColorModel(null, (int)0, (int)selectedBands.length, (int)paletteIndex, palette, (boolean)true, (int)-1);
        } else {
            gray = Math.max(gray, 0);
            Band band = selectedBands[gray];
            double min = band.getValue(gdal.getRasterMinimum, MemorySegment.NULL);
            double max = band.getValue(gdal.getRasterMaximum, MemorySegment.NULL);
            this.colorModel = ColorModelFactory.createGrayScale((int)this.dataType.imageType, (int)selectedBands.length, (int)gray, (double)min, (double)max);
        }
        this.sampleModel = new BandedSampleModel(this.dataType.imageType, this.tileWidth, this.tileHeight, selectedBands.length);
        this.selectedBandIndices = bandIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColorModel getColorModel(int[] bandIndices) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.colorModel == null || !Arrays.equals(bandIndices, this.selectedBandIndices)) {
                this.createColorAndSampleModel(bandIndices);
            }
            return this.colorModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SampleModel getSampleModel(int[] bandIndices) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.sampleModel == null || !Arrays.equals(bandIndices, this.selectedBandIndices)) {
                this.createColorAndSampleModel(bandIndices);
            }
            return this.sampleModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number[] getFillValues(int[] bandIndices) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.fillValues == null) {
                Number[] fillValues = new Number[]{bandIndices != null ? bandIndices.length : this.bands.length};
                GDAL gdal = this.parent.getProvider().GDAL();
                boolean hasNonZero = false;
                try (Arena arena = Arena.ofConfined();){
                    MemorySegment flag = arena.allocate(ValueLayout.JAVA_INT);
                    for (int i = 0; i < fillValues.length; ++i) {
                        int b = bandIndices != null ? bandIndices[i] : i;
                        double value = this.bands[b].getValue(gdal.getRasterNoDataValue, flag);
                        hasNonZero |= value != 0.0;
                        if (Band.isTrue(flag)) continue;
                        hasNonZero = false;
                        break;
                    }
                }
                this.fillValues = hasNonZero ? fillValues : ExtendedPrecisionMatrix.CREATE_ZERO;
            }
            return this.fillValues.length != 0 ? this.fillValues : null;
        }
    }

    protected boolean canReadTruncatedTiles(int dim, boolean suggested) {
        return true;
    }

    protected final int[] getTileSize() {
        return new int[]{this.tileWidth, this.tileHeight};
    }

    protected long[] getVirtualTileSize(long[] subsampling) {
        return new long[]{Math.min(Math.multiplyExact(subsampling[0], this.tileWidth), Integer.toUnsignedLong(this.width)), Math.min(Math.multiplyExact(subsampling[1], this.tileHeight), Integer.toUnsignedLong(this.height))};
    }

    final void clipReadRegion(Rectangle r) {
        long max = Integer.toUnsignedLong(this.width) - (long)r.x;
        if ((long)r.width > max) {
            r.width = Math.toIntExact(max);
        }
        if ((long)r.height > (max = Integer.toUnsignedLong(this.height) - (long)r.y)) {
            r.height = Math.toIntExact(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            GridCoverage gridCoverage;
            try {
                TiledGridResource.Subset subset = new TiledGridResource.Subset((TiledGridResource)this, domain, ranges);
                TiledCoverage result = new TiledCoverage(this, subset);
                gridCoverage = this.preload((GridCoverage)result);
            }
            catch (Throwable throwable) {
                ErrorHandler.report(this.parent, "read");
                throw throwable;
            }
            ErrorHandler.report(this.parent, "read");
            return gridCoverage;
        }
    }

    private record SizeAndType(int width, int height, int type, int tileWidth, int tileHeight) {
        Dimension tileSize() {
            int h;
            int w = this.tileWidth;
            if (w < 1 || Integer.compareUnsigned(w, this.width) >= 0 || (h = this.tileHeight) < 1 || Integer.compareUnsigned(h, this.height) >= 0) {
                w = this.width;
                if (w < 0) {
                    w = 256;
                }
                if ((h = this.height) < 0) {
                    h = 256;
                }
            } else if (Math.multiplyFull(w, h) <= 0x1000000L) {
                return new Dimension(w, h);
            }
            return ImageLayout.DEFAULT.suggestTileSize(w, h);
        }
    }
}

