/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.wcm.commons.caching.ModificationDateProvider;
import java.util.Date;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ProviderType
public interface Rendition
extends Adaptable,
ModificationDateProvider {
    @Nullable
    public String getUrl();

    @Nullable
    public String getPath();

    @Nullable
    public String getFileName();

    @Nullable
    public String getFileExtension();

    public long getFileSize();

    @Nullable
    public String getMimeType();

    @JsonUnwrapped
    @Nullable
    public MediaFormat getMediaFormat();

    @JsonIgnore
    @NotNull
    public ValueMap getProperties();

    @JsonIgnore
    public boolean isImage();

    @JsonIgnore
    public boolean isBrowserImage();

    @JsonIgnore
    public boolean isVectorImage();

    @Deprecated
    @JsonIgnore
    public boolean isFlash();

    @JsonIgnore
    public boolean isDownload();

    public long getWidth();

    public long getHeight();

    default public double getRatio() {
        long width = this.getWidth();
        long height = this.getHeight();
        if (width > 0L && height > 0L) {
            return Ratio.get(width, height);
        }
        return 0.0;
    }

    @JsonIgnore
    @Nullable
    public Date getModificationDate();
}

