/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.AbstractInstallTask;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class RestartActiveBundlesTask
extends AbstractInstallTask {
    private static final String SORT_KEY = "99-org.apache.sling.installer.core.restart.bundles";
    private static final String ATTR = "bundles";

    public RestartActiveBundlesTask(TaskResourceGroup erl, TaskSupport support) {
        super(erl, support);
        HashSet<Long> ids = (HashSet<Long>)erl.getActiveResource().getAttribute(ATTR);
        if (ids == null) {
            ids = new HashSet<Long>();
        }
        for (Bundle bundle : support.getBundleContext().getBundles()) {
            if (bundle.getBundleId() <= 0L || BundleUtil.getFragmentHostHeader(bundle) != null || bundle.getState() != 32) continue;
            ids.add(bundle.getBundleId());
        }
        erl.getActiveResource().setAttribute(ATTR, ids);
    }

    @Override
    public void execute(InstallationContext ctx) {
        Set ids = (Set)this.getResource().getAttribute(ATTR);
        int started = 0;
        if (ids != null) {
            HashSet<Long> remove = new HashSet<Long>();
            for (Long id : ids) {
                Bundle bundle = this.getBundleContext().getBundle(id.longValue());
                if (bundle != null && bundle.getState() != 32 && bundle.getState() != 8 && bundle.getState() != 16 && bundle.getState() != 1) {
                    try {
                        bundle.start();
                        ++started;
                        ctx.log("Started bundle {}", bundle);
                        remove.add(id);
                    }
                    catch (BundleException e) {
                        this.getLogger().info("Unable to start bundle {} : {}", (Object)bundle, (Object)e.getMessage());
                    }
                    catch (IllegalStateException ie) {
                        this.getLogger().info("Unable to start bundle {} : {}", (Object)bundle, (Object)ie.getMessage());
                        remove.add(id);
                    }
                    continue;
                }
                this.getLogger().debug("Bundle does not need restart: {} (state {})", (Object)bundle, bundle == null ? "uninstalled" : Integer.valueOf(bundle.getState()));
                remove.add(id);
            }
            ids.removeAll(remove);
        }
        this.getLogger().debug("{} bundles were started", (Object)started);
    }

    @Override
    public String getSortKey() {
        return SORT_KEY;
    }
}

