/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderJsonTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = this.context.uniqueRoot().content();
        try {
            NodeTypeDefinitionScanner.get().register((Session)this.context.resourceResolver().adaptTo(Session.class), List.of("SLING-INF/nodetypes/app.cnd"), this.getResourceResolverType().getNodeTypeMode());
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to register namespaces.", ex);
        }
        this.context.load().json("/json-import-samples/content.json", this.path + "/sample/en");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testPageResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en");
        Assert.assertEquals((Object)"app:Page", (Object)resource.getResourceType());
    }

    @Test
    public void testPageJcrPrimaryType() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en");
        this.assertPrimaryNodeType(resource, "app:Page");
    }

    @Test
    public void testPageContentMixinTypes() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        this.assertMixinTypes(resource, "app:TestMixin");
    }

    @Test
    public void testPageContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/toolbar/profiles/jcr:content");
        Assert.assertEquals((Object)"sample/components/contentpage", (Object)resource.getResourceType());
    }

    @Test
    public void testPageContentJcrPrimaryType() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/toolbar/profiles/jcr:content");
        this.assertPrimaryNodeType(resource, "app:PageContent");
    }

    @Test
    public void testPageContentProperties() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/toolbar/profiles/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)true, (Object)props.get("hideInNav", Boolean.class));
        Assert.assertEquals((Object)1234567890123L, (Object)props.get("longProp", Long.class));
        Assert.assertEquals((double)1.2345, (double)((Double)props.get("decimalProp", Double.class)), (double)1.0E-5);
        Assert.assertEquals((Object)true, (Object)props.get("booleanProp", Boolean.class));
        Assert.assertArrayEquals((Object[])new Long[]{1234567890123L, 55L}, (Object[])((Object[])props.get("longPropMulti", Long[].class)));
        Assert.assertArrayEquals((Object[])new Double[]{1.2345, 1.1}, (Object[])((Object[])props.get("decimalPropMulti", Double[].class)));
        Assert.assertArrayEquals((Object[])new Boolean[]{true, false}, (Object[])((Object[])props.get("booleanPropMulti", Boolean[].class)));
    }

    @Test
    public void testContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content/header");
        Assert.assertEquals((Object)"sample/components/header", (Object)resource.getResourceType());
    }

    @Test
    public void testContentJcrPrimaryType() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content/header");
        this.assertPrimaryNodeType(resource, "nt:unstructured");
    }

    @Test
    public void testContentProperties() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content/header");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"/content/dam/sample/header.png", (Object)props.get("imageReference", String.class));
    }

    private void assertPrimaryNodeType(Resource resource, String nodeType) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Assert.assertEquals((Object)nodeType, (Object)node.getPrimaryNodeType().getName());
        } else {
            ValueMap props = ResourceUtil.getValueMap((Resource)resource);
            Assert.assertEquals((Object)nodeType, (Object)props.get((Object)"jcr:primaryType"));
        }
    }

    private void assertMixinTypes(Resource resource, String ... mixinTypes) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Assert.assertArrayEquals((Object[])mixinTypes, (Object[])Stream.of(node.getMixinNodeTypes()).map(NodeTypeDefinition::getName).toArray(String[]::new));
        } else {
            ValueMap props = ResourceUtil.getValueMap((Resource)resource);
            Assert.assertArrayEquals((Object[])mixinTypes, (Object[])((Object[])props.get("jcr:mixinTypes", String[].class)));
        }
    }

    @Test
    public void testCalendarEcmaFormat() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Calendar calendar = (Calendar)props.get("app:lastModified", Calendar.class);
        Assert.assertNotNull((Object)calendar);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+2"));
        Assert.assertEquals((long)2014L, (long)calendar.get(1));
        Assert.assertEquals((long)4L, (long)(calendar.get(2) + 1));
        Assert.assertEquals((long)22L, (long)calendar.get(5));
        Assert.assertEquals((long)15L, (long)calendar.get(11));
        Assert.assertEquals((long)11L, (long)calendar.get(12));
        Assert.assertEquals((long)24L, (long)calendar.get(13));
    }

    @Test
    public void testCalendarISO8601Format() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Calendar calendar = (Calendar)props.get("dateISO8601String", Calendar.class);
        Assert.assertNotNull((Object)calendar);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+2"));
        Assert.assertEquals((long)2014L, (long)calendar.get(1));
        Assert.assertEquals((long)4L, (long)(calendar.get(2) + 1));
        Assert.assertEquals((long)22L, (long)calendar.get(5));
        Assert.assertEquals((long)15L, (long)calendar.get(11));
        Assert.assertEquals((long)11L, (long)calendar.get(12));
        Assert.assertEquals((long)24L, (long)calendar.get(13));
    }

    @Test
    public void testUTF8Chars() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df\u20ac", (Object)props.get((Object)"utf8Property"));
    }

    @Test
    public void testJcrUuid() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content/par/image/file/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"eda76d00-b2cd-4b59-878f-c33f71ceaddc", (Object)props.get((Object)"jcr:uuid"));
    }

    @Test
    public void testJcrCreated() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content/par/image/file");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertNotNull((Object)props.get((Object)"jcr:created"));
    }
}

