/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.trident.functions;

import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.trident.operation.OperationAwareMapFunction;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationFunction
implements OperationAwareMapFunction {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationFunction.class);
    private final ExecutableExpression projectionInstance;
    private final Object[] outputValues;
    private final DataContext dataContext;

    public EvaluationFunction(ExecutableExpression projectionInstance, int outputCount, DataContext dataContext) {
        this.projectionInstance = projectionInstance;
        this.outputValues = new Object[outputCount];
        this.dataContext = dataContext;
    }

    public void prepare(Map conf, TridentOperationContext context) {
        if (this.projectionInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code: {}", (Object)((DebuggableExecutableExpression)this.projectionInstance).getDelegateCode());
        }
    }

    public void cleanup() {
    }

    public Values execute(TridentTuple input) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = input.getValues().toArray();
        this.projectionInstance.execute(calciteContext, this.outputValues);
        return new Values(this.outputValues);
    }
}

