/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.cocode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sysml.runtime.compress.cocode.PlanningCoCodingGroup;
import org.apache.sysml.runtime.compress.estim.CompressedSizeEstimator;

public class PlanningMemoTable {
    private HashMap<PlanningCoCodingGroup.ColIndexes, PlanningCoCodingGroup> _memo = new HashMap();
    private double _optChangeInSize = 0.0;
    private int[] _stats = new int[3];

    public PlanningCoCodingGroup getOrCreate(PlanningCoCodingGroup c1, PlanningCoCodingGroup c2, CompressedSizeEstimator estim, int numRows) {
        PlanningCoCodingGroup.ColIndexes c1c2Indexes = new PlanningCoCodingGroup.ColIndexes(PlanningCoCodingGroup.getMergedIndexes(c1.getColIndices(), c2.getColIndices()));
        PlanningCoCodingGroup c1c2 = this._memo.get(c1c2Indexes);
        this.incrStats(0, 1, 0);
        if (c1c2 == null) {
            c1c2 = new PlanningCoCodingGroup(c1, c2, estim, numRows);
            this._memo.put(c1c2Indexes, c1c2);
            this._optChangeInSize = Math.min(this._optChangeInSize, c1c2.getChangeInSize());
            this.incrStats(0, 0, 1);
        }
        return c1c2;
    }

    public void remove(PlanningCoCodingGroup grp) {
        this._memo.remove(new PlanningCoCodingGroup.ColIndexes(grp.getColIndices()));
        this._memo.remove(new PlanningCoCodingGroup.ColIndexes(grp.getLeftGroup().getColIndices()));
        this._memo.remove(new PlanningCoCodingGroup.ColIndexes(grp.getRightGroup().getColIndices()));
        this._optChangeInSize = 0.0;
        Iterator<Map.Entry<PlanningCoCodingGroup.ColIndexes, PlanningCoCodingGroup>> iter = this._memo.entrySet().iterator();
        while (iter.hasNext()) {
            PlanningCoCodingGroup tmp = iter.next().getValue();
            if (Arrays.equals(tmp.getLeftGroup().getColIndices(), grp.getLeftGroup().getColIndices()) || Arrays.equals(tmp.getLeftGroup().getColIndices(), grp.getRightGroup().getColIndices()) || Arrays.equals(tmp.getRightGroup().getColIndices(), grp.getLeftGroup().getColIndices()) || Arrays.equals(tmp.getRightGroup().getColIndices(), grp.getRightGroup().getColIndices())) {
                iter.remove();
                continue;
            }
            this._optChangeInSize = Math.min(this._optChangeInSize, tmp.getChangeInSize());
        }
    }

    public void incrStats(int v1, int v2, int v3) {
        this._stats[0] = this._stats[0] + v1;
        this._stats[1] = this._stats[1] + v2;
        this._stats[2] = this._stats[2] + v3;
    }

    public double getOptChangeInSize() {
        return this._optChangeInSize;
    }

    public int[] getStats() {
        return this._stats;
    }
}

