/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.VariableSet;

public class FunctionStatement
extends Statement {
    private ArrayList<StatementBlock> _body = new ArrayList();
    protected String _name = null;
    protected ArrayList<DataIdentifier> _inputParams = new ArrayList();
    protected ArrayList<Expression> _inputDefaults = new ArrayList();
    protected ArrayList<DataIdentifier> _outputParams = new ArrayList();

    @Override
    public Statement rewriteStatement(String prefix) {
        throw new LanguageException(this.printErrorLocation() + "should not call rewriteStatement for FunctionStatement");
    }

    public ArrayList<DataIdentifier> getInputParams() {
        return this._inputParams;
    }

    public DataIdentifier getInputParam(String name) {
        return this._inputParams.stream().filter(d -> d.getName().equals(name)).findFirst().orElse(null);
    }

    public ArrayList<Expression> getInputDefaults() {
        return this._inputDefaults;
    }

    public Expression getInputDefault(String name) {
        for (int i = 0; i < this._inputParams.size(); ++i) {
            if (!this._inputParams.get(i).getName().equals(name)) continue;
            return this._inputDefaults.get(i);
        }
        return null;
    }

    public ArrayList<DataIdentifier> getOutputParams() {
        return this._outputParams;
    }

    public void setInputParams(ArrayList<DataIdentifier> inputParams) {
        this._inputParams = inputParams;
    }

    public void setInputDefaults(ArrayList<Expression> inputDefaults) {
        this._inputDefaults = inputDefaults;
    }

    public void setOutputParams(ArrayList<DataIdentifier> outputParams) {
        this._outputParams = outputParams;
    }

    public void setName(String fname) {
        this._name = fname;
    }

    public String getName() {
        return this._name;
    }

    public ArrayList<StatementBlock> getBody() {
        return this._body;
    }

    public void setBody(ArrayList<StatementBlock> body) {
        this._body = body;
    }

    @Override
    public boolean controlStatement() {
        return true;
    }

    public void mergeStatementBlocks() {
        this._body = StatementBlock.mergeStatementBlocks(this._body);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this._name + " = ");
        sb.append("function ( ");
        for (i = 0; i < this._inputParams.size(); ++i) {
            DataIdentifier curr = this._inputParams.get(i);
            sb.append(curr.getName());
            if (i >= this._inputParams.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") return (");
        for (i = 0; i < this._outputParams.size(); ++i) {
            sb.append(this._outputParams.get(i).getName());
            if (i >= this._outputParams.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") { \n");
        for (StatementBlock block : this._body) {
            sb.append(block.toString());
        }
        sb.append("} \n");
        return sb.toString();
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for FunctionStatement");
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        throw new LanguageException(this.printErrorLocation() + "should never call initializeforwardLV for FunctionStatement");
    }

    @Override
    public VariableSet variablesRead() {
        LOG.warn((Object)(this.printWarningLocation() + " -- should not call variablesRead from FunctionStatement "));
        return new VariableSet();
    }

    @Override
    public VariableSet variablesUpdated() {
        LOG.warn((Object)(this.printWarningLocation() + " -- should not call variablesRead from FunctionStatement "));
        return new VariableSet();
    }
}

