/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import java.io.Serializable;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Or;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class AggregateOperator
extends Operator
implements Serializable {
    private static final long serialVersionUID = 8761527329665129670L;
    public final double initialValue;
    public final BinaryOperator increOp;
    public final Types.CorrectionLocationType correction;

    public AggregateOperator(double initValue, ValueFunction op) {
        this(initValue, op, Types.CorrectionLocationType.INVALID);
    }

    public AggregateOperator(double initValue, ValueFunction op, Types.CorrectionLocationType correctionLocation) {
        super(op instanceof Plus || op instanceof KahanPlus || op instanceof KahanPlusSq || op instanceof Or || op instanceof Minus);
        this.initialValue = initValue;
        this.increOp = new BinaryOperator(op);
        this.correction = correctionLocation;
    }

    public boolean existsCorrection() {
        return this.correction != Types.CorrectionLocationType.NONE && this.correction != Types.CorrectionLocationType.INVALID || this.increOp.fn.requiresCorrection();
    }
}

