/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy;

import java.util.EnumMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public class PrivacyMonitor {
    private static EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraints = new EnumMap(PrivacyConstraint.PrivacyLevel.class);
    private static boolean checkPrivacy;

    public static EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder> getCheckedConstraints() {
        return checkedConstraints;
    }

    private static void incrementCheckedConstraints(PrivacyConstraint.PrivacyLevel privacyLevel) {
        if (checkPrivacy) {
            if (privacyLevel == null) {
                throw new NullPointerException("Cannot increment checked constraints log: Privacy level is null.");
            }
            checkedConstraints.get((Object)privacyLevel).increment();
        }
    }

    public static void clearCheckedConstraints() {
        checkedConstraints.replaceAll((k, v) -> new LongAdder());
    }

    public static void setCheckPrivacy(boolean checkPrivacyParam) {
        checkPrivacy = checkPrivacyParam;
    }

    public static Data handlePrivacy(Data dataObject) {
        PrivacyConstraint privacyConstraint = dataObject.getPrivacyConstraint();
        if (privacyConstraint != null) {
            PrivacyConstraint.PrivacyLevel privacyLevel = privacyConstraint.getPrivacyLevel();
            PrivacyMonitor.incrementCheckedConstraints(privacyLevel);
            switch (privacyLevel) {
                case None: {
                    dataObject.setPrivacyConstraints(null);
                    break;
                }
                case Private: 
                case PrivateAggregation: {
                    throw new DMLPrivacyException("Cannot share variable, since the privacy constraint of the requested variable is set to " + privacyLevel.name());
                }
                default: {
                    throw new DMLPrivacyException("Privacy level " + privacyLevel.name() + " of variable not recognized");
                }
            }
        }
        return dataObject;
    }

    public static Data handlePrivacyAllowAggregation(Data dataObject) {
        PrivacyConstraint privacyConstraint = dataObject.getPrivacyConstraint();
        if (privacyConstraint != null) {
            PrivacyConstraint.PrivacyLevel privacyLevel = privacyConstraint.getPrivacyLevel();
            PrivacyMonitor.incrementCheckedConstraints(privacyLevel);
            switch (privacyLevel) {
                case None: {
                    dataObject.setPrivacyConstraints(null);
                    break;
                }
                case Private: {
                    throw new DMLPrivacyException("Cannot share variable, since the privacy constraint of the requested variable is set to " + privacyLevel.name());
                }
                case PrivateAggregation: {
                    break;
                }
                default: {
                    throw new DMLPrivacyException("Privacy level " + privacyLevel.name() + " of variable not recognized");
                }
            }
        }
        return dataObject;
    }

    static {
        for (PrivacyConstraint.PrivacyLevel level : PrivacyConstraint.PrivacyLevel.values()) {
            checkedConstraints.put(level, new LongAdder());
        }
        checkPrivacy = false;
    }
}

