/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    protected SequenceFile.Writer getSequenceWriter(TaskAttemptContext context, Class<?> keyClass, Class<?> valueClass) throws IOException {
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileOutputFormat.getCompressOutput(context)) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType(context);
            Class<CompressionCodec> codecClass = SequenceFileOutputFormat.getOutputCompressorClass(context, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        }
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, keyClass, valueClass, (SequenceFile.CompressionType)compressionType, (CompressionCodec)codec, (Progressable)context);
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        final SequenceFile.Writer out = this.getSequenceWriter(context, context.getOutputKeyClass(), context.getOutputValueClass());
        return new RecordWriter<K, V>(){

            @Override
            public void write(K key, V value) throws IOException {
                out.append(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    public static SequenceFile.CompressionType getOutputCompressionType(JobContext job) {
        String val = job.getConfiguration().get("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.RECORD.toString());
        return SequenceFile.CompressionType.valueOf((String)val);
    }

    public static void setOutputCompressionType(Job job, SequenceFile.CompressionType style) {
        SequenceFileOutputFormat.setCompressOutput(job, true);
        job.getConfiguration().set("mapreduce.output.fileoutputformat.compress.type", style.toString());
    }
}

