/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.random.SamplingUtils;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.BasicTensorBlock;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.data.TensorIndexes;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.Statistics;
import scala.Array;
import scala.Tuple2;

public class RandSPInstruction
extends UnarySPInstruction {
    private static final Log LOG = LogFactory.getLog((String)RandSPInstruction.class.getName());
    private static final long INMEMORY_NUMBLOCKS_THRESHOLD = 0x100000L;
    private Types.OpOpDG _method = null;
    private final CPOperand rows;
    private final CPOperand cols;
    private final CPOperand dims;
    private int blocksize;
    private final double minValue;
    private final double maxValue;
    private final String minValueStr;
    private final String maxValueStr;
    private final double sparsity;
    private final String pdf;
    private final String pdfParams;
    private final String frame_data;
    private final String schema;
    private long seed = 0L;
    private final String dir;
    private final CPOperand seq_from;
    private final CPOperand seq_to;
    private final CPOperand seq_incr;
    private Long runtimeSeed;
    private final boolean replace;
    private static final int SEED_POSITION_RAND = 8;
    private static final int SEED_POSITION_SAMPLE = 4;

    private RandSPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String minValue, String maxValue, double sparsity, long seed, String dir, String probabilityDensityFunction, String pdfParams, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, boolean replace, String fdata, String schema, String opcode, String istr) {
        super(SPInstruction.SPType.Rand, op, in, out, opcode, istr);
        double maxDouble;
        double minDouble;
        this._method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.dims = dims;
        this.blocksize = blen;
        this.minValueStr = minValue;
        this.maxValueStr = maxValue;
        try {
            minDouble = !minValue.contains("\u00b6") ? Double.valueOf(minValue) : -1.0;
            maxDouble = !maxValue.contains("\u00b6") ? Double.valueOf(maxValue) : -1.0;
        }
        catch (NumberFormatException e) {
            if (!this.minValueStr.equals(this.maxValueStr)) {
                throw new DMLRuntimeException("Rand instruction does not support non numeric Datatypes for range initializations.");
            }
            minDouble = -1.0;
            maxDouble = -1.0;
        }
        this.minValue = minDouble;
        this.maxValue = maxDouble;
        this.sparsity = sparsity;
        this.seed = seed;
        this.dir = dir;
        this.pdf = probabilityDensityFunction;
        this.pdfParams = pdfParams;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
        this.replace = replace;
        this.frame_data = fdata;
        this.schema = schema;
    }

    private RandSPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String minValue, String maxValue, double sparsity, long seed, String dir, String probabilityDensityFunction, String pdfParams, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, minValue, maxValue, sparsity, seed, dir, probabilityDensityFunction, pdfParams, null, null, null, false, null, null, opcode, istr);
    }

    private RandSPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, "-1", "-1", -1.0, -1L, null, null, null, seqFrom, seqTo, seqIncr, false, null, null, opcode, istr);
    }

    private RandSPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String maxValue, boolean replace, long seed, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, "-1", maxValue, -1.0, seed, null, null, null, null, null, null, replace, null, null, opcode, istr);
    }

    private RandSPInstruction(Operator op, Types.OpOpDG mthd, CPOperand out, CPOperand rows, CPOperand cols, String fdata, String schema, String opcode, String istr) {
        this(op, mthd, null, out, rows, cols, null, 0, "0", "1", 0.0, 0L, null, null, null, null, null, null, false, fdata, schema, opcode, istr);
    }

    public long getRows() {
        return this.rows.isLiteral() ? UtilFunctions.parseToLong(this.rows.getName()) : -1L;
    }

    public long getCols() {
        return this.cols.isLiteral() ? UtilFunctions.parseToLong(this.cols.getName()) : -1L;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public long getSeed() {
        return this.seed;
    }

    public String getDims() {
        return this.dims.getName();
    }

    public String getPdf() {
        return this.pdf;
    }

    public String getPdfParams() {
        return this.pdfParams;
    }

    public static RandSPInstruction parseInstruction(String str) {
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        Types.OpOpDG method = null;
        if (opcode.equalsIgnoreCase("rand")) {
            method = Types.OpOpDG.RAND;
            InstructionUtils.checkNumFields(str, 10, 11);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Types.OpOpDG.SEQ;
            InstructionUtils.checkNumFields(str, 7);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Types.OpOpDG.SAMPLE;
            InstructionUtils.checkNumFields(str, 6);
        } else if (opcode.equalsIgnoreCase("frame")) {
            method = Types.OpOpDG.FRAMEINIT;
            InstructionUtils.checkNumFields(str, 6);
        }
        Operator op = null;
        CPOperand out = new CPOperand(s[s.length - 1]);
        if (method == Types.OpOpDG.RAND) {
            int missing;
            CPOperand rows = null;
            CPOperand cols = null;
            CPOperand dims = null;
            if (s.length == 12) {
                missing = 1;
                rows = new CPOperand(s[1]);
                cols = new CPOperand(s[2]);
            } else {
                missing = 2;
                dims = new CPOperand(s[1]);
            }
            int blen = Integer.parseInt(s[4 - missing]);
            double sparsity = !s[7 - missing].contains("\u00b6") ? Double.parseDouble(s[7 - missing]) : -1.0;
            long seed = !s[8 - missing].contains("\u00b6") ? Long.parseLong(s[8 - missing]) : -1L;
            String dir = s[9 - missing];
            String pdf = s[10 - missing];
            String pdfParams = !s[11 - missing].contains("\u00b6") ? s[11 - missing] : null;
            return new RandSPInstruction(op, method, null, out, rows, cols, dims, blen, s[5 - missing], s[6 - missing], sparsity, seed, dir, pdf, pdfParams, opcode, str);
        }
        if (method == Types.OpOpDG.SEQ) {
            int blen = Integer.parseInt(s[3]);
            CPOperand from = new CPOperand(s[4]);
            CPOperand to = new CPOperand(s[5]);
            CPOperand incr = new CPOperand(s[6]);
            CPOperand in = null;
            return new RandSPInstruction(op, method, in, out, null, null, null, blen, from, to, incr, opcode, str);
        }
        if (method == Types.OpOpDG.SAMPLE) {
            String max = !s[1].contains("\u00b6") ? s[1] : "0";
            CPOperand rows = new CPOperand(s[2]);
            CPOperand cols = new CPOperand("1", Types.ValueType.INT64, Types.DataType.SCALAR);
            boolean replace = !s[3].contains("\u00b6") && Boolean.valueOf(s[3]) != false;
            long seed = Long.parseLong(s[4]);
            int blen = Integer.parseInt(s[5]);
            return new RandSPInstruction(op, method, null, out, rows, cols, null, blen, max, replace, seed, opcode, str);
        }
        if (method == Types.OpOpDG.FRAMEINIT) {
            String data = s[1];
            CPOperand rows = new CPOperand(s[2]);
            CPOperand cols = new CPOperand(s[3]);
            String valueType = s[4];
            return new RandSPInstruction(op, method, out, rows, cols, data, valueType, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        switch (this._method) {
            case RAND: {
                this.generateRandData(sec);
                break;
            }
            case SEQ: {
                this.generateSequence(sec);
                break;
            }
            case SAMPLE: {
                this.generateSample(sec);
                break;
            }
            case FRAMEINIT: {
                this.generateFrame(sec);
                break;
            }
            default: {
                throw new DMLRuntimeException("Invalid datagen method: " + (Object)((Object)this._method));
            }
        }
    }

    private void generateFrame(SparkExecutionContext sec) {
        Types.ValueType[] vt;
        MatrixCharacteristics tmp;
        int brlen;
        JavaPairRDD seedsRDD;
        String data;
        long lcols;
        long lrows;
        block9: {
            double hdfsBlkSize;
            double totalSize;
            Well1024a bigrand;
            block8: {
                lrows = sec.getScalarInput(this.rows).getLongValue();
                lcols = sec.getScalarInput(this.cols).getLongValue();
                data = this.frame_data;
                long lSeed = this.generateRandomSeed();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction frame with seed = " + lSeed + "."));
                }
                seedsRDD = null;
                bigrand = LibMatrixDatagen.setupSeedsForRand(lSeed);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(lrows, lcols, -1L, 1L);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                brlen = ConfigurationManager.getBlocksize();
                tmp = new MatrixCharacteristics(lrows, lcols, brlen);
                if (((DataCharacteristics)tmp).getNumRowBlocks() >= 0x100000L) break block8;
                ArrayList<Tuple2> seeds = new ArrayList<Tuple2>();
                for (long i = 0L; i < ((DataCharacteristics)tmp).getNumRowBlocks(); ++i) {
                    Long seedForBlock = bigrand.nextLong();
                    seeds.add(new Tuple2((Object)(i * (long)brlen + 1L), (Object)seedForBlock));
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)((DataCharacteristics)tmp).getNumRowBlocks()), 1.0);
                seedsRDD = sec.getSparkContext().parallelizePairs(seeds, numPartitions);
                break block9;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                StringBuilder sb = new StringBuilder();
                for (long i = 0L; i < ((DataCharacteristics)tmp).getNumRowBlocks(); ++i) {
                    sb.append(i * (long)brlen + 1L);
                    sb.append(',');
                    sb.append(bigrand.nextLong());
                    pw.println(sb.toString());
                    sb.setLength(0);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)((DataCharacteristics)tmp).getNumRowBlocks()), 1.0);
            seedsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).mapToPair((PairFunction)new ExtractFrameSeedTuple());
        }
        String[] schemaValues = this.schema.split("\u00b7");
        Types.ValueType[] valueTypeArray = vt = schemaValues[0].equals("NULL") ? UtilFunctions.nCopies((int)lcols, Types.ValueType.STRING) : UtilFunctions.stringToValueType(schemaValues);
        if ((long)vt.length != lcols) {
            throw new DMLRuntimeException("schema-dimension mismatch: " + vt.length + " vs " + lcols);
        }
        JavaPairRDD out = seedsRDD.mapToPair((PairFunction)new GenerateRandomFrameBlock(lrows, lcols, brlen, vt, data));
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.getDataCharacteristics(this.output.getName()).set(tmp);
    }

    private void generateRandData(SparkExecutionContext sec) {
        if (this.output.getDataType() == Types.DataType.MATRIX) {
            this.generateRandDataMatrix(sec);
        } else {
            this.generateRandDataTensor(sec);
        }
        this.runtimeSeed = null;
    }

    private void generateRandDataMatrix(SparkExecutionContext sec) {
        JavaPairRDD seedsRDD;
        long lcols;
        long lrows;
        block11: {
            long numColBlocks;
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            Well1024a bigrand;
            block10: {
                lrows = sec.getScalarInput(this.rows).getLongValue();
                lcols = sec.getScalarInput(this.cols).getLongValue();
                long lSeed = this.generateRandomSeed();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction rand with seed = " + lSeed + "."));
                }
                if (ConfigurationManager.isDynamicRecompilation() && RandSPInstruction.isMemAvail(lrows, lcols, this.sparsity, this.minValue, this.maxValue) && DMLScript.getGlobalExecMode() != Types.ExecMode.SPARK) {
                    RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)lrows, (int)lcols, this.blocksize, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
                    MatrixBlock mb = MatrixBlock.randOperations(rgen, lSeed);
                    sec.setMatrixOutput(this.output.getName(), mb);
                    Statistics.decrementNoOfExecutedSPInst();
                    return;
                }
                seedsRDD = null;
                bigrand = LibMatrixDatagen.setupSeedsForRand(lSeed);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(lrows, lcols, (long)this.blocksize, this.sparsity);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                MatrixCharacteristics tmp = new MatrixCharacteristics(lrows, lcols, this.blocksize);
                numBlocks = ((DataCharacteristics)tmp).getNumBlocks();
                numColBlocks = ((DataCharacteristics)tmp).getNumColBlocks();
                if (numBlocks >= 0x100000L) break block10;
                ArrayList<Tuple2> seeds = new ArrayList<Tuple2>();
                for (long i = 0L; i < numBlocks; ++i) {
                    long r = 1L + i / numColBlocks;
                    long c = 1L + i % numColBlocks;
                    MatrixIndexes indx = new MatrixIndexes(r, c);
                    Long seedForBlock = bigrand.nextLong();
                    seeds.add(new Tuple2((Object)indx, (Object)seedForBlock));
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                seedsRDD = sec.getSparkContext().parallelizePairs(seeds, numPartitions);
                break block11;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                StringBuilder sb = new StringBuilder();
                for (long i = 0L; i < numBlocks; ++i) {
                    sb.append(1L + i / numColBlocks);
                    sb.append(',');
                    sb.append(1L + i % numColBlocks);
                    sb.append(',');
                    sb.append(bigrand.nextLong());
                    pw.println(sb.toString());
                    sb.setLength(0);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            seedsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).mapToPair((PairFunction)new ExtractMatrixSeedTuple());
        }
        JavaPairRDD out = seedsRDD.mapToPair((PairFunction)new GenerateRandomBlock(lrows, lcols, this.blocksize, this.sparsity, this.minValue, this.maxValue, this.pdf, this.pdfParams));
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown(true)) {
            long lnnz = this.sparsity == 0.0 || this.sparsity == 1.0 ? (long)(this.sparsity * (double)lrows * (double)lcols) : -1L;
            mcOut.set(lrows, lcols, this.blocksize, lnnz);
            if (!mcOut.nnzKnown()) {
                mcOut.setNonZerosBound((long)(this.sparsity * (double)lrows * (double)lcols));
            }
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateRandDataTensor(SparkExecutionContext sec) {
        JavaPairRDD seedsRDD;
        TensorCharacteristics tmp;
        int[] tDims;
        block11: {
            int numPartitions;
            long numBlocks;
            Well1024a bigrand;
            block10: {
                tDims = DataConverter.getTensorDimensions(sec, this.dims);
                long lSeed = this.generateRandomSeed();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction rand with seed = " + lSeed + "."));
                }
                bigrand = LibMatrixDatagen.setupSeedsForRand(lSeed);
                this.blocksize = TensorCharacteristics.DEFAULT_BLOCK_SIZE[tDims.length - 2];
                long[] longDims = new long[tDims.length];
                long totalSize = 1L;
                long hdfsBlkSize = this.blocksize * tDims.length;
                for (int i = 0; i < tDims.length; ++i) {
                    longDims[i] = tDims[i];
                    totalSize *= (long)tDims[i];
                }
                tmp = new TensorCharacteristics(longDims, this.blocksize, 0L);
                numBlocks = tmp.getNumBlocks();
                numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, numBlocks), 1L);
                if (numBlocks >= 0x100000L) break block10;
                ArrayList<Tuple2> seeds = new ArrayList<Tuple2>();
                long[] ix = new long[tmp.getNumDims()];
                Arrays.fill(ix, 1L);
                for (long i = 0L; i < numBlocks; ++i) {
                    TensorIndexes indx = new TensorIndexes(ix);
                    Long seedForBlock = bigrand.nextLong();
                    seeds.add(new Tuple2((Object)indx, (Object)seedForBlock));
                    UtilFunctions.computeNextTensorIndexes(tmp, ix);
                }
                seedsRDD = sec.getSparkContext().parallelizePairs(seeds, numPartitions);
                break block11;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                StringBuilder sb = new StringBuilder();
                long[] blockIx = new long[tmp.getNumDims()];
                Arrays.fill(blockIx, 1L);
                for (long i = 0L; i < numBlocks; ++i) {
                    for (int j = tmp.getNumDims() - 1; j >= 0; --j) {
                        sb.append(blockIx[j]).append(',');
                    }
                    sb.append(bigrand.nextLong());
                    pw.println(sb.toString());
                    sb.setLength(0);
                    UtilFunctions.computeNextTensorIndexes(tmp, blockIx);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            seedsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).mapToPair((PairFunction)new ExtractTensorSeedTuple());
        }
        JavaPairRDD out = seedsRDD.mapToPair((PairFunction)new GenerateRandomTensorBlock(this.output.getValueType(), tDims, this.blocksize, this.sparsity, this.minValueStr, this.maxValueStr, this.pdf, this.pdfParams));
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown(true)) {
            mcOut.set(tmp);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSequence(SparkExecutionContext sec) {
        long nnz;
        JavaRDD offsetsRDD;
        double lincr;
        double lto;
        double lfrom;
        block10: {
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            block9: {
                lfrom = sec.getScalarInput(this.seq_from).getDoubleValue();
                lto = sec.getScalarInput(this.seq_to).getDoubleValue();
                lincr = sec.getScalarInput(this.seq_incr).getDoubleValue();
                if (lincr == 0.0) {
                    throw new DMLRuntimeException("ERROR: While performing seq(" + lfrom + "," + lto + "," + lincr + ")");
                }
                lincr = LibMatrixDatagen.updateSeqIncr(lfrom, lto, lincr);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction seq with seqFrom=" + lfrom + ", seqTo=" + lto + ", seqIncr" + lincr));
                }
                offsetsRDD = null;
                nnz = UtilFunctions.getSeqLength(lfrom, lto, lincr);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(nnz, 1L, (long)this.blocksize, nnz);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                numBlocks = (long)Math.ceil((double)nnz / (double)this.blocksize);
                if (numBlocks >= 0x100000L) break block9;
                ArrayList<Double> offsets = new ArrayList<Double>();
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = lfrom + lincr * (double)i * (double)this.blocksize;
                    offsets.add(off);
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                offsetsRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
                break block10;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = lfrom + lincr * (double)i * (double)this.blocksize;
                    pw.println(off);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            offsetsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).map((Function)new ExtractOffsetTuple());
        }
        JavaPairRDD out = offsetsRDD.mapToPair((PairFunction)new GenerateSequenceBlock(this.blocksize, lfrom, lto, lincr));
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown()) {
            mcOut.set(nnz, 1L, this.blocksize, nnz);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSample(SparkExecutionContext sec) {
        long lrows = sec.getScalarInput(this.rows).getLongValue();
        if (this.maxValue < (double)lrows && !this.replace) {
            throw new DMLRuntimeException("Sample (size=" + this.rows + ") larger than population (size=" + this.maxValue + ") can only be generated with replacement.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process RandSPInstruction sample with range=" + this.maxValue + ", size=" + lrows + ", replace=" + this.replace + ", seed=" + this.seed));
        }
        double fraction = SamplingUtils.computeFractionForSampleSize((int)((int)lrows), (long)UtilFunctions.toLong(this.maxValue), (boolean)this.replace);
        Well1024a bigrand = LibMatrixDatagen.setupSeedsForRand(this.seed);
        double hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
        long outputSize = MatrixBlock.estimateSizeDenseInMemory(lrows, 1L);
        int numPartitions = (int)Math.ceil((double)outputSize / hdfsBlockSize);
        long partitionSize = (long)Math.ceil(this.maxValue / (double)numPartitions);
        ArrayList<SampleTask> offsets = new ArrayList<SampleTask>();
        long st = 1L;
        while ((double)st <= this.maxValue) {
            SampleTask s = new SampleTask();
            s.range_start = st;
            s.seed = bigrand.nextLong();
            offsets.add(s);
            st += partitionSize;
        }
        JavaRDD offsetRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
        JavaRDD rdd = offsetRDD.flatMap((FlatMapFunction)new GenerateSampleBlock(this.replace, fraction, (long)this.maxValue, partitionSize));
        JavaRDD randomizedRDD = rdd.mapToPair((PairFunction)new AttachRandom()).sortByKey().values();
        JavaPairRDD miRDD = randomizedRDD.zipWithIndex().filter((Function)new TrimSample(lrows)).mapToPair((PairFunction)new Double2MatrixCell());
        MatrixCharacteristics mcOut = new MatrixCharacteristics(lrows, 1L, this.blocksize, lrows);
        JavaPairRDD<MatrixIndexes, MatrixBlock> mbRDD = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), (JavaPairRDD<MatrixIndexes, MatrixCell>)miRDD, mcOut, true);
        sec.getDataCharacteristics(this.output.getName()).setNonZeros(lrows);
        sec.setRDDHandleForVariable(this.output.getName(), mbRDD);
    }

    private long generateRandomSeed() {
        long lSeed = this.seed;
        if (lSeed == -1L) {
            if (this.runtimeSeed == null) {
                this.runtimeSeed = DataGenOp.generateRandomSeed();
            }
            lSeed = this.runtimeSeed;
        }
        return lSeed;
    }

    private static boolean isMemAvail(long lrows, long lcols, double sparsity, double min, double max) {
        double size = min == 0.0 && max == 0.0 ? (double)OptimizerUtils.estimateSizeEmptyBlock(lrows, lcols) : (double)OptimizerUtils.estimateSizeExactSparsity(lrows, lcols, sparsity);
        return OptimizerUtils.isValidCPDimensions(lrows, lcols) && OptimizerUtils.isValidCPMatrixSize(lrows, lcols, sparsity) && size < OptimizerUtils.getLocalMemBudget();
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String tmpInstStr = this.instString;
        if (this.getSeed() == -1L) {
            if (this.runtimeSeed == null) {
                this.runtimeSeed = this.minValue == this.maxValue && this.sparsity == 1.0 ? -1L : DataGenOp.generateRandomSeed();
            }
            int position = this._method == Types.OpOpDG.RAND ? 8 : (this._method == Types.OpOpDG.SAMPLE ? 4 : 0);
            tmpInstStr = InstructionUtils.replaceOperand(tmpInstStr, position, String.valueOf(this.runtimeSeed));
            if (!this.rows.isLiteral()) {
                tmpInstStr = InstructionUtils.replaceOperand(tmpInstStr, 2, new CPOperand(ec.getScalarInput(this.rows)).getLineageLiteral());
            }
            if (!this.cols.isLiteral()) {
                tmpInstStr = InstructionUtils.replaceOperand(tmpInstStr, 3, new CPOperand(ec.getScalarInput(this.cols)).getLineageLiteral());
            }
        }
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(tmpInstStr, this.getOpcode()));
    }

    private static class GenerateSequenceBlock
    implements PairFunction<Double, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5779681055705756965L;
        private final double _global_seq_start;
        private final double _global_seq_end;
        private final double _seq_incr;
        private final int _blen;

        public GenerateSequenceBlock(int blen, double global_seq_start, double global_seq_end, double seq_incr) {
            this._global_seq_start = global_seq_start;
            this._global_seq_end = global_seq_end;
            this._seq_incr = seq_incr;
            this._blen = blen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Double seq_from) throws Exception {
            double seq_to = this._seq_incr > 0.0 ? Math.min(this._global_seq_end, seq_from + this._seq_incr * (double)(this._blen - 1)) : Math.max(this._global_seq_end, seq_from + this._seq_incr * (double)(this._blen + 1));
            long globalRow = Math.round((seq_from - this._global_seq_start) / this._seq_incr) + 1L;
            long rowIndex = UtilFunctions.computeBlockIndex(globalRow, this._blen);
            MatrixIndexes indx = new MatrixIndexes(rowIndex, 1L);
            MatrixBlock blk = MatrixBlock.seqOperations(seq_from, seq_to, this._seq_incr);
            return new Tuple2((Object)indx, (Object)blk);
        }
    }

    private static class GenerateRandomTensorBlock
    implements PairFunction<Tuple2<TensorIndexes, Long>, TensorIndexes, TensorBlock> {
        private static final long serialVersionUID = -512119897654170462L;
        private Types.ValueType _vt;
        private int[] _dims;
        private int _blen;
        private double _sparsity;
        private String _min;
        private String _max;
        private String _pdf;
        private String _pdfParams;

        public GenerateRandomTensorBlock(Types.ValueType vt, int[] dims, int blen, double sparsity, String min, String max, String pdf, String pdfParams) {
            this._vt = vt;
            this._dims = new int[dims.length];
            Array.copy((Object)dims, (int)0, (Object)this._dims, (int)0, (int)dims.length);
            this._blen = blen;
            this._sparsity = sparsity;
            this._min = min;
            this._max = max;
            this._pdf = pdf;
            this._pdfParams = pdfParams;
        }

        public Tuple2<TensorIndexes, TensorBlock> call(Tuple2<TensorIndexes, Long> kv) throws Exception {
            TensorIndexes ix = (TensorIndexes)kv._1();
            int[] blockDims = new int[this._dims.length];
            blockDims[0] = UtilFunctions.computeBlockSize(this._dims[0], ix.getIndex(0), this._blen);
            for (int i = 1; i < this._dims.length; ++i) {
                blockDims[i] = UtilFunctions.computeBlockSize(this._dims[i], ix.getIndex(i), this._blen);
            }
            int clen = (int)UtilFunctions.prod(blockDims, 1);
            long seed = (Long)kv._2;
            BasicTensorBlock tb = new BasicTensorBlock(this._vt, blockDims);
            tb.allocateDenseBlock();
            if (!this._min.equals(this._max)) {
                if (this._vt == Types.ValueType.STRING) {
                    throw new DMLRuntimeException("Random string data can not be generated for tensors.");
                }
                MatrixBlock blk = new MatrixBlock();
                RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this._pdf, blockDims[0], clen, this._blen, this._sparsity, Double.parseDouble(this._min), Double.parseDouble(this._max), this._pdfParams);
                blk.randOperationsInPlace(rgen, null, seed);
                blk.examSparsity();
                tb.set(blk);
            } else {
                switch (this._vt) {
                    case STRING: 
                    case BOOLEAN: {
                        tb.set(this._min);
                        break;
                    }
                    case INT64: 
                    case INT32: {
                        tb.set(Long.parseLong(this._min));
                        break;
                    }
                    default: {
                        tb.set(Double.parseDouble(this._min));
                    }
                }
            }
            return new Tuple2(kv._1, (Object)new TensorBlock(tb));
        }
    }

    private static class GenerateRandomBlock
    implements PairFunction<Tuple2<MatrixIndexes, Long>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 1616346120426470173L;
        private long _rlen;
        private long _clen;
        private int _blen;
        private double _sparsity;
        private double _min;
        private double _max;
        private String _pdf;
        private String _pdfParams;

        public GenerateRandomBlock(long rlen, long clen, int blen, double sparsity, double min, double max, String pdf, String pdfParams) {
            this._rlen = rlen;
            this._clen = clen;
            this._blen = blen;
            this._sparsity = sparsity;
            this._min = min;
            this._max = max;
            this._pdf = pdf;
            this._pdfParams = pdfParams;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, Long> kv) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)kv._1();
            long blockRowIndex = ix.getRowIndex();
            long blockColIndex = ix.getColumnIndex();
            int lrlen = UtilFunctions.computeBlockSize(this._rlen, blockRowIndex, this._blen);
            int lclen = UtilFunctions.computeBlockSize(this._clen, blockColIndex, this._blen);
            long seed = (Long)kv._2;
            MatrixBlock blk = new MatrixBlock();
            RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this._pdf, lrlen, lclen, this._blen, this._sparsity, this._min, this._max, this._pdfParams);
            blk.randOperationsInPlace(rgen, null, seed);
            blk.examSparsity();
            return new Tuple2(kv._1, (Object)blk);
        }
    }

    private static class GenerateRandomFrameBlock
    implements PairFunction<Tuple2<Long, Long>, Long, FrameBlock> {
        private static final long serialVersionUID = 1616346120426470173L;
        private final long _rlen;
        private final long _clen;
        private final int _brlen;
        private final Types.ValueType[] _schema;
        private final String _data;

        public GenerateRandomFrameBlock(long rlen, long clen, int brlen, Types.ValueType[] schema, String fdata) {
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._schema = schema;
            this._data = fdata;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, Long> kv) throws Exception {
            Long ix = (Long)kv._1();
            long blockix = UtilFunctions.computeBlockIndex(ix, this._brlen);
            int lrlen = UtilFunctions.computeBlockSize(this._rlen, blockix, this._brlen);
            FrameBlock out = null;
            if (this._data.equals("")) {
                out = UtilFunctions.generateRandomFrameBlock((int)this._rlen, (int)this._clen, this._schema, new Random(10L));
            } else {
                Object[] data = this._data.split("\u00b7");
                int rowLength = data.length / (int)this._rlen;
                if (data.length != this._schema.length && data.length > 1 && rowLength != this._schema.length) {
                    throw new DMLRuntimeException("data values should be equal to number of columns, or a single values for all columns");
                }
                if (data.length > 1 && rowLength != this._schema.length) {
                    out = new FrameBlock(this._schema);
                    for (int i = 0; i < lrlen; ++i) {
                        out.appendRow((String[])data);
                    }
                } else if (data.length > 1 && rowLength == this._schema.length) {
                    out = new FrameBlock(this._schema);
                    int beg = 0;
                    for (int i = 1; i <= lrlen; ++i) {
                        int end = (int)this._clen * i;
                        String[] data1 = (String[])ArrayUtils.subarray((Object[])data, (int)beg, (int)end);
                        beg = end;
                        out.appendRow(data1);
                    }
                } else {
                    out = new FrameBlock(this._schema);
                    Object[] data1 = new String[(int)this._clen];
                    Arrays.fill(data1, this._data);
                    for (int i = 0; i < lrlen; ++i) {
                        out.appendRow((String[])data1);
                    }
                }
            }
            return new Tuple2(kv._1, (Object)out);
        }
    }

    private static class ExtractOffsetTuple
    implements Function<String, Double> {
        private static final long serialVersionUID = -3980257526545002552L;

        private ExtractOffsetTuple() {
        }

        public Double call(String arg) throws Exception {
            return Double.parseDouble(arg);
        }
    }

    private static class ExtractTensorSeedTuple
    implements PairFunction<String, TensorIndexes, Long> {
        private static final long serialVersionUID = 3973794676854157101L;

        private ExtractTensorSeedTuple() {
        }

        public Tuple2<TensorIndexes, Long> call(String arg) throws Exception {
            String[] parts = IOUtilFunctions.split(arg, ",");
            long[] ix = new long[parts.length - 1];
            for (int i = 0; i < parts.length - 1; ++i) {
                ix[i] = Long.parseLong(parts[i]);
            }
            TensorIndexes to = new TensorIndexes(ix);
            return new Tuple2((Object)to, (Object)Long.parseLong(parts[parts.length - 1]));
        }
    }

    private static class ExtractMatrixSeedTuple
    implements PairFunction<String, MatrixIndexes, Long> {
        private static final long serialVersionUID = 3973794676854157101L;

        private ExtractMatrixSeedTuple() {
        }

        public Tuple2<MatrixIndexes, Long> call(String arg) throws Exception {
            String[] parts = IOUtilFunctions.split(arg, ",");
            MatrixIndexes ix = new MatrixIndexes(Long.parseLong(parts[0]), Long.parseLong(parts[1]));
            return new Tuple2((Object)ix, (Object)Long.parseLong(parts[2]));
        }
    }

    private static class ExtractFrameSeedTuple
    implements PairFunction<String, Long, Long> {
        private static final long serialVersionUID = 3973794676854157100L;

        private ExtractFrameSeedTuple() {
        }

        public Tuple2<Long, Long> call(String arg) throws Exception {
            String[] parts = IOUtilFunctions.split(arg, ",");
            Long ix = Long.parseLong(parts[0]);
            return new Tuple2((Object)ix, (Object)Long.parseLong(parts[1]));
        }
    }

    private static class AttachRandom
    implements PairFunction<Double, Double, Double> {
        private static final long serialVersionUID = -7508858192367406554L;
        Random r = new Random();

        AttachRandom() {
        }

        public Tuple2<Double, Double> call(Double t) throws Exception {
            return new Tuple2((Object)this.r.nextDouble(), (Object)t);
        }
    }

    private static class Double2MatrixCell
    implements PairFunction<Tuple2<Double, Long>, MatrixIndexes, MatrixCell> {
        private static final long serialVersionUID = -2125669746624320536L;

        private Double2MatrixCell() {
        }

        public Tuple2<MatrixIndexes, MatrixCell> call(Tuple2<Double, Long> t) throws Exception {
            long rowID = (Long)t._2() + 1L;
            MatrixIndexes mi = new MatrixIndexes(rowID, 1L);
            MatrixCell mc = new MatrixCell((Double)t._1());
            return new Tuple2((Object)mi, (Object)mc);
        }
    }

    private static class TrimSample
    implements Function<Tuple2<Double, Long>, Boolean> {
        private static final long serialVersionUID = 6773370625013346530L;
        long _max;

        TrimSample(long max) {
            this._max = max;
        }

        public Boolean call(Tuple2<Double, Long> v1) throws Exception {
            return (Long)v1._2 < this._max;
        }
    }

    private static class GenerateSampleBlock
    implements FlatMapFunction<SampleTask, Double> {
        private static final long serialVersionUID = -8211490954143527232L;
        private double _frac;
        private boolean _replace;
        private long _maxValue;
        private long _partitionSize;

        GenerateSampleBlock(boolean replace, double frac, long max, long psize) {
            this._replace = replace;
            this._frac = frac;
            this._maxValue = max;
            this._partitionSize = psize;
        }

        public Iterator<Double> call(SampleTask t) throws Exception {
            long st = t.range_start;
            long end = Math.min(t.range_start + this._partitionSize, this._maxValue);
            ArrayList<Double> retList = new ArrayList<Double>();
            if (this._frac == 1.0) {
                for (long i = st; i <= end; ++i) {
                    retList.add(Double.valueOf(i));
                }
            } else if (this._replace) {
                PoissonDistribution pdist = new PoissonDistribution(this._frac > 0.0 ? this._frac : 1.0);
                for (long i = st; i <= end; ++i) {
                    for (int count = pdist.sample(); count > 0; --count) {
                        retList.add(Double.valueOf(i));
                    }
                }
            } else {
                Random rnd = new Random(t.seed);
                for (long i = st; i <= end; ++i) {
                    if (!(rnd.nextDouble() < this._frac)) continue;
                    retList.add(Double.valueOf(i));
                }
            }
            return retList.iterator();
        }
    }

    private static class SampleTask
    implements Serializable {
        private static final long serialVersionUID = -725284524434342939L;
        long seed;
        long range_start;

        private SampleTask() {
        }

        public String toString() {
            return "(" + this.seed + "," + this.range_start + ")";
        }
    }
}

