/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.operators;

import org.apache.sysds.lops.WeightedCrossEntropy;
import org.apache.sysds.lops.WeightedDivMM;
import org.apache.sysds.lops.WeightedSigmoid;
import org.apache.sysds.lops.WeightedSquaredLoss;
import org.apache.sysds.lops.WeightedUnaryMM;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Multiply2;
import org.apache.sysds.runtime.functionobjects.Power2;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class QuaternaryOperator
extends Operator {
    private static final long serialVersionUID = -1642908613016116069L;
    public final WeightedSquaredLoss.WeightsType wtype1;
    public final WeightedSigmoid.WSigmoidType wtype2;
    public final WeightedDivMM.WDivMMType wtype3;
    public final WeightedCrossEntropy.WCeMMType wtype4;
    public final WeightedUnaryMM.WUMMType wtype5;
    public final ValueFunction fn;
    private final double eps;

    private QuaternaryOperator(WeightedSquaredLoss.WeightsType wt1, WeightedSigmoid.WSigmoidType wt2, WeightedDivMM.WDivMMType wt3, WeightedCrossEntropy.WCeMMType wt4, WeightedUnaryMM.WUMMType wt5, ValueFunction fn, double eps) {
        this.wtype1 = wt1;
        this.wtype2 = wt2;
        this.wtype3 = wt3;
        this.wtype4 = wt4;
        this.wtype5 = wt5;
        this.fn = fn;
        this.eps = eps;
    }

    public QuaternaryOperator(WeightedSquaredLoss.WeightsType wt) {
        this(wt, null, null, null, null, null, 0.0);
    }

    public QuaternaryOperator(WeightedSigmoid.WSigmoidType wt) {
        this(null, wt, null, null, null, Builtin.getBuiltinFnObject("sigmoid"), 0.0);
    }

    public QuaternaryOperator(WeightedDivMM.WDivMMType wt) {
        this(null, null, wt, null, null, null, 0.0);
    }

    public QuaternaryOperator(WeightedDivMM.WDivMMType wt, double epsilon) {
        this(null, null, wt, null, null, null, epsilon);
    }

    public QuaternaryOperator(WeightedCrossEntropy.WCeMMType wt) {
        this(null, null, null, wt, null, null, 0.0);
    }

    public QuaternaryOperator(WeightedCrossEntropy.WCeMMType wt, double epsilon) {
        this(null, null, null, wt, null, null, epsilon);
    }

    public QuaternaryOperator(WeightedUnaryMM.WUMMType wt, String op) {
        this(null, null, null, null, wt, op.equals("^2") ? Power2.getPower2FnObject() : (op.equals("*2") ? Multiply2.getMultiply2FnObject() : Builtin.getBuiltinFnObject(op)), 0.0);
    }

    public boolean hasFourInputs() {
        return this.wtype1 != null && this.wtype1.hasFourInputs() || this.wtype3 != null && this.wtype3.hasFourInputs() || this.wtype4 != null && this.wtype4.hasFourInputs();
    }

    public double getScalar() {
        return this.eps;
    }
}

