/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashIntegerArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.RaggedArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.utils.MemoryEstimates;

public interface ArrayFactory {
    public static final Log LOG = LogFactory.getLog((String)ArrayFactory.class.getName());
    public static final int bitSetSwitchPoint = 64;

    public static StringArray create(String[] col) {
        return new StringArray(col);
    }

    public static HashLongArray createHash64I(long[] col) {
        return new HashLongArray(col);
    }

    public static HashLongArray createHash64(String[] col) {
        return new HashLongArray(col);
    }

    public static HashIntegerArray createHash32I(int[] col) {
        return new HashIntegerArray(col);
    }

    public static HashIntegerArray createHash32(String[] col) {
        return new HashIntegerArray(col);
    }

    public static OptionalArray<Object> createHash64Opt(String[] col) {
        return new OptionalArray<Object>(col, Types.ValueType.HASH64);
    }

    public static OptionalArray<Object> createHash64OptI(long[] col) {
        return new OptionalArray<Object>(new HashLongArray(col), false);
    }

    public static OptionalArray<Object> createHash32Opt(String[] col) {
        return new OptionalArray<Object>(col, Types.ValueType.HASH32);
    }

    public static OptionalArray<Object> createHash32OptI(int[] col) {
        return new OptionalArray<Object>(new HashIntegerArray(col), false);
    }

    public static HashLongArray createHash64(long[] col) {
        return new HashLongArray(col);
    }

    public static HashIntegerArray createHash32(int[] col) {
        return new HashIntegerArray(col);
    }

    public static BooleanArray create(boolean[] col) {
        return new BooleanArray(col);
    }

    public static BitSetArray create(BitSet col, int size) {
        return new BitSetArray(col, size);
    }

    public static IntegerArray create(int[] col) {
        return new IntegerArray(col);
    }

    public static LongArray create(long[] col) {
        return new LongArray(col);
    }

    public static FloatArray create(float[] col) {
        return new FloatArray(col);
    }

    public static DoubleArray create(double[] col) {
        return new DoubleArray(col);
    }

    public static CharArray create(char[] col) {
        return new CharArray(col);
    }

    public static <T> Array<T> create(T[] col) {
        if (col instanceof String[]) {
            return new StringArray((String[])col);
        }
        return new OptionalArray<T>(col);
    }

    public static <T> RaggedArray<T> create(T[] col, int m) {
        return new RaggedArray<T>(col, m);
    }

    public static long getInMemorySize(Types.ValueType type, int _numRows, boolean containsNull) {
        if (containsNull) {
            switch (type) {
                case HASH32: {
                    type = Types.ValueType.INT32;
                }
                case HASH64: {
                    type = Types.ValueType.INT64;
                }
                case BOOLEAN: 
                case INT64: 
                case FP64: 
                case UINT4: 
                case UINT8: 
                case INT32: 
                case FP32: 
                case CHARACTER: {
                    return ArrayFactory.getInMemorySize(type, _numRows, false) + ArrayFactory.getInMemorySize(Types.ValueType.BOOLEAN, _numRows, false) + 16L + Array.baseMemoryCost();
                }
                case STRING: {
                    return Array.baseMemoryCost() + MemoryEstimates.stringCost(12L) * (long)_numRows;
                }
            }
            throw new DMLRuntimeException("Invalid type to estimate size of :" + type);
        }
        switch (type) {
            case BOOLEAN: {
                if (_numRows > 64) {
                    return BitSetArray.estimateInMemorySize(_numRows);
                }
                return BooleanArray.estimateInMemorySize(_numRows);
            }
            case HASH64: 
            case INT64: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.longArrayCost(_numRows);
            }
            case FP64: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.doubleArrayCost(_numRows);
            }
            case HASH32: 
            case UINT4: 
            case UINT8: 
            case INT32: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.intArrayCost(_numRows);
            }
            case FP32: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.floatArrayCost(_numRows);
            }
            case STRING: {
                return Array.baseMemoryCost() + MemoryEstimates.stringCost(12L) * (long)_numRows;
            }
            case CHARACTER: {
                return Array.baseMemoryCost() + (long)MemoryEstimates.charArrayCost(_numRows);
            }
        }
        throw new DMLRuntimeException("Invalid type to estimate size of :" + type);
    }

    public static Array<?> allocate(Types.ValueType v, int nRow, String val) {
        Array<?> a = ArrayFactory.allocate(v, nRow);
        a.fill(val);
        return a;
    }

    public static Array<?> allocate(Types.ValueType v, int nRow, boolean optional) {
        return optional ? ArrayFactory.allocateOptional(v, nRow) : ArrayFactory.allocate(v, nRow);
    }

    public static Array<?> allocateOptional(Types.ValueType v, int nRow) {
        switch (v) {
            case HASH32: 
            case HASH64: 
            case BOOLEAN: 
            case INT64: 
            case FP64: 
            case UINT4: 
            case UINT8: 
            case INT32: 
            case FP32: 
            case CHARACTER: {
                return new OptionalArray(ArrayFactory.allocate(v, nRow), true);
            }
        }
        return new StringArray(new String[nRow]);
    }

    public static ABooleanArray allocateBoolean(int nRow) {
        if (nRow > 64) {
            return new BitSetArray(nRow);
        }
        return new BooleanArray(new boolean[nRow]);
    }

    public static Array<?> allocate(Types.ValueType v, int nRow) {
        switch (v) {
            case BOOLEAN: {
                return ArrayFactory.allocateBoolean(nRow);
            }
            case UINT4: 
            case UINT8: {
                LOG.warn((Object)"Not supported allocation of UInt 4 or 8 array: defaulting to Int32");
            }
            case INT32: {
                return new IntegerArray(new int[nRow]);
            }
            case INT64: {
                return new LongArray(new long[nRow]);
            }
            case FP32: {
                return new FloatArray(new float[nRow]);
            }
            case FP64: {
                return new DoubleArray(new double[nRow]);
            }
            case CHARACTER: {
                return new CharArray(new char[nRow]);
            }
            case HASH64: {
                return new HashLongArray(new long[nRow]);
            }
            case HASH32: {
                return new HashIntegerArray(new int[nRow]);
            }
        }
        return new StringArray(new String[nRow]);
    }

    public static Array<?> read(DataInput in, int nRow) throws IOException {
        FrameArrayType v = FrameArrayType.values()[in.readByte()];
        switch (v) {
            case BITSET: {
                return BitSetArray.read(in, nRow);
            }
            case BOOLEAN: {
                return BooleanArray.read(in, nRow);
            }
            case FP32: {
                return FloatArray.read(in, nRow);
            }
            case FP64: {
                return DoubleArray.read(in, nRow);
            }
            case INT32: {
                return IntegerArray.read(in, nRow);
            }
            case INT64: {
                return LongArray.read(in, nRow);
            }
            case CHARACTER: {
                return CharArray.read(in, nRow);
            }
            case RAGGED: {
                return RaggedArray.read(in, nRow);
            }
            case OPTIONAL: {
                return OptionalArray.read(in, nRow);
            }
            case DDC: {
                return DDCArray.read(in);
            }
            case HASH32: {
                return HashIntegerArray.read(in, nRow);
            }
            case HASH64: {
                return HashLongArray.read(in, nRow);
            }
        }
        return StringArray.read(in, nRow);
    }

    public static <C> Array<C> append(Array<?> a, Array<?> b) {
        Types.ValueType tb;
        Types.ValueType tc;
        Types.ValueType ta = a.getValueType();
        Array<?> ac = ta != (tc = Types.ValueType.getHighestCommonType(ta, tb = b.getValueType())) ? a.changeType(tc) : a;
        Array<?> bc = tb != tc ? b.changeType(tc) : b;
        return ac.append(bc);
    }

    public static <C> Array<C> set(Array<?> target, Array<?> src, int rl, int ru, int rlen) {
        if (rlen <= ru) {
            throw new DMLRuntimeException("Invalid range ru: " + ru + " should be less than rlen: " + rlen);
        }
        if (rl < 0) {
            throw new DMLRuntimeException("Invalid rl is less than zero");
        }
        if (src == null) {
            throw new NullPointerException("Invalid src, cannot be null");
        }
        if (ru - rl > src.size()) {
            throw new DMLRuntimeException("Invalid range length to big: " + src.size() + " vs range: " + (ru - rl));
        }
        if (target != null && target.size() < rlen) {
            throw new DMLRuntimeException("Invalid allocated target is not large enough");
        }
        if (target == null) {
            DDCArray ddcA;
            Array ddcDict;
            target = src.getFrameArrayType() == FrameArrayType.OPTIONAL ? ArrayFactory.allocateOptional(src.getValueType(), rlen) : (src.getFrameArrayType() == FrameArrayType.DDC ? ((ddcDict = (ddcA = (DDCArray)src).getDict()) == null ? new DDCArray(null, MapToFactory.create(rlen, ddcA.getMap().getUnique())) : (ddcDict.getFrameArrayType() == FrameArrayType.OPTIONAL ? ArrayFactory.allocateOptional(src.getValueType(), rlen) : ArrayFactory.allocate(src.getValueType(), rlen))) : ArrayFactory.allocate(src.getValueType(), rlen));
        } else if (target.getFrameArrayType() != FrameArrayType.OPTIONAL && src.getFrameArrayType() == FrameArrayType.OPTIONAL) {
            target = new OptionalArray(target, false);
        }
        Types.ValueType ta = target.getValueType();
        Types.ValueType tb = src.getValueType();
        Types.ValueType tc = Types.ValueType.getHighestCommonType(ta, tb);
        Array targetC = ta != tc ? target.changeType(tc) : target;
        Array<?> srcC = tb != tc ? src.changeType(tc) : src;
        targetC.set(rl, ru, srcC, 0);
        return targetC;
    }

    public static Object parseString(String s, Types.ValueType v) {
        switch (v) {
            case BOOLEAN: {
                return BooleanArray.parseBoolean(s);
            }
            case CHARACTER: {
                return Character.valueOf(CharArray.parseChar(s));
            }
            case FP32: {
                return Float.valueOf(FloatArray.parseFloat(s));
            }
            case FP64: {
                return DoubleArray.parseDouble(s);
            }
            case UINT4: 
            case UINT8: 
            case INT32: {
                return IntegerArray.parseInt(s);
            }
            case INT64: {
                return LongArray.parseLong(s);
            }
            case HASH64: {
                return HashLongArray.parseHashLong(s);
            }
            case HASH32: {
                return HashIntegerArray.parseHashInt(s);
            }
        }
        return s;
    }

    public static Object defaultNullValue(Types.ValueType v) {
        return ArrayFactory.parseString(null, v);
    }

    public static enum FrameArrayType {
        STRING,
        BOOLEAN,
        BITSET,
        INT32,
        INT64,
        FP32,
        FP64,
        CHARACTER,
        RAGGED,
        OPTIONAL,
        DDC,
        HASH64,
        HASH32;

    }
}

